/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Strings;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class DispatchType
extends HttpCondition {
    private final DispatcherType type;

    private DispatchType(DispatcherType type) {
        this.type = type;
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        return this.type.equals((Object)this.getDispatcherType(event));
    }

    private DispatcherType getDispatcherType(HttpServletRewrite event) {
        return ((HttpServletRequest)event.getRequest()).getDispatcherType();
    }

    public static DispatchType isForward() {
        return new DispatchType(DispatcherType.FORWARD);
    }

    public static DispatchType isRequest() {
        return new DispatchType(DispatcherType.REQUEST);
    }

    public static DispatchType isError() {
        return new DispatchType(DispatcherType.ERROR);
    }

    public static DispatchType isAsync() {
        return new DispatchType(DispatcherType.ASYNC);
    }

    public static DispatchType isInclude() {
        return new DispatchType(DispatcherType.INCLUDE);
    }

    public String toString() {
        return "DispatchType.is" + Strings.capitalize((String)(this.type.toString().toLowerCase() + "()"));
    }
}

