/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.bind;

import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.RewriteWrappedRequest;
import org.ocpsoft.rewrite.servlet.event.ServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.util.Maps;

public abstract class RequestBinding
implements Binding {
    public static RequestBinding attribute(final String property) {
        return new RequestAttributeBinding(property){

            public String toString() {
                return "RequestBinding.attribute(\"" + property + "\")";
            }
        };
    }

    public static RequestBinding parameter(final String property) {
        return new RequestParameterBinding(property){

            public String toString() {
                return "RequestBinding.parameter(\"" + property + "\")";
            }
        };
    }

    public boolean supportsRetrieval() {
        return true;
    }

    public boolean supportsSubmission() {
        return true;
    }

    private static class RequestAttributeBinding
    extends RequestBinding {
        private final String name;

        public RequestAttributeBinding(String attribute) {
            this.name = attribute;
        }

        public Object submit(Rewrite event, EvaluationContext context, Object value) {
            ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).setAttribute(this.name, value);
            return null;
        }

        public Object retrieve(Rewrite event, EvaluationContext context) {
            if (event instanceof HttpServletRewrite) {
                return ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).getParameter(this.name);
            }
            return null;
        }
    }

    private static class RequestParameterBinding
    extends RequestBinding {
        private final String name;

        public RequestParameterBinding(String parameter) {
            this.name = parameter;
        }

        public Object submit(Rewrite event, EvaluationContext context, Object value) {
            ServletRequest request = ((ServletRewrite)event).getRequest();
            RewriteWrappedRequest wrapper = RewriteWrappedRequest.getCurrentInstance((ServletRequest)request);
            Map modifiableParameters = wrapper.getModifiableParameters();
            if (value != null) {
                if (value.getClass().isArray()) {
                    Object[] values;
                    for (Object object : values = (Object[])value) {
                        Maps.addArrayValue((Map)modifiableParameters, (Object)this.name, (String)object.toString());
                    }
                } else {
                    Maps.addArrayValue((Map)modifiableParameters, (Object)this.name, (String)value.toString());
                }
            } else {
                Maps.addArrayValue((Map)modifiableParameters, (Object)this.name, null);
            }
            return null;
        }

        public Object retrieve(Rewrite event, EvaluationContext context) {
            return ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).getParameter(this.name);
        }
    }
}

