/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public abstract class Scheme
extends HttpCondition
implements Parameterized {
    private final ParameterizedPatternParser expression;

    private Scheme(String pattern) {
        Assert.notNull((Object)pattern, (String)"Scheme must not be null.");
        this.expression = new RegexParameterizedPatternParser(pattern);
    }

    public static Scheme matches(final String pattern) {
        return new Scheme(pattern){

            public String toString() {
                return "Scheme.matches(\"" + pattern + "\")";
            }
        };
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String scheme = null;
        if (event instanceof HttpOutboundServletRewrite) {
            scheme = event.getAddress().getScheme();
            if (scheme == null) {
                scheme = ((HttpServletRequest)event.getRequest()).getScheme();
            }
        } else {
            scheme = ((HttpServletRequest)event.getRequest()).getScheme();
        }
        return scheme != null && this.expression.matches((Rewrite)event, context, scheme);
    }

    public ParameterizedPatternParser getExpression() {
        return this.expression;
    }

    public Set<String> getRequiredParameterNames() {
        return this.expression.getRequiredParameterNames();
    }

    public void setParameterStore(ParameterStore store) {
        this.expression.setParameterStore(store);
    }
}

