/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Set;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ConfigurableParameter;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.bind.RequestBinding;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.urlbuilder.Address;

public class URL
extends HttpCondition
implements Parameterized {
    private final ParameterizedPatternParser expression;
    private boolean requestBinding;

    private URL(String pattern) {
        Assert.notNull((Object)pattern, (String)"URL must not be null.");
        this.expression = new RegexParameterizedPatternParser(".*", pattern);
    }

    public static URL matches(String pattern) {
        return new URL(pattern);
    }

    public static URL captureIn(String param) {
        URL path = new URL("{" + param + "}");
        return path;
    }

    public URL withRequestBinding() {
        this.requestBinding = true;
        return this;
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String requestURL = null;
        if (event instanceof HttpOutboundServletRewrite) {
            requestURL = ((Address)((HttpOutboundServletRewrite)event).getOutboundAddress()).toString();
            if (requestURL.startsWith(event.getContextPath())) {
                requestURL = requestURL.substring(event.getContextPath().length());
            }
        } else {
            requestURL = event.getAddress().toString();
        }
        return this.expression.matches((Rewrite)event, context, requestURL);
    }

    public ParameterizedPatternParser getSchemeExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }

    public ParameterizedPatternParser getPathExpression() {
        return this.expression;
    }

    public Set<String> getRequiredParameterNames() {
        return this.expression.getRequiredParameterNames();
    }

    public void setParameterStore(ParameterStore store) {
        if (this.requestBinding) {
            for (String param : this.getRequiredParameterNames()) {
                Parameter parameter = store.get(param);
                if (!(parameter instanceof ConfigurableParameter)) continue;
                ((ConfigurableParameter)parameter).bindsTo((Binding)RequestBinding.parameter(param));
            }
        }
        this.expression.setParameterStore(store);
    }
}

