/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.lifecycle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.config.CompositeOperation;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.DefaultOperationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.ContextBase;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.context.RewriteState;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.param.ParameterValueStoreImpl;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class Subset
extends DefaultOperationBuilder
implements CompositeOperation {
    private static Logger log = Logger.getLogger(Subset.class);
    private final Configuration config;

    private Subset(Configuration config) {
        Assert.notNull((Object)config, (String)"Configuration must not be null.");
        this.config = config;
    }

    public static Subset when(Configuration config) {
        return new Subset(config);
    }

    public void perform(Rewrite rewrite, EvaluationContext context) {
        HttpServletRewrite event = (HttpServletRewrite)rewrite;
        ArrayList<Rule> cacheable = new ArrayList<Rule>();
        List rules = this.config.getRules();
        EvaluationContextImpl subContext = new EvaluationContextImpl();
        for (int i = 0; i < rules.size(); ++i) {
            Rule rule = (Rule)rules.get(i);
            subContext.clear();
            ParameterValueStoreImpl values = new ParameterValueStoreImpl();
            subContext.put(ParameterValueStore.class, values);
            if (!rule.evaluate((Rewrite)event, (EvaluationContext)subContext)) continue;
            if (!this.handleBindings(event, subContext, values)) break;
            log.debug("Rule [" + rule + "] matched and will be performed.");
            cacheable.add(rule);
            List<Operation> preOperations = subContext.getPreOperations();
            for (int k = 0; k < preOperations.size(); ++k) {
                preOperations.get(k).perform((Rewrite)event, (EvaluationContext)subContext);
            }
            if (event.getFlow().is(BaseRewrite.Flow.HANDLED)) break;
            rule.perform((Rewrite)event, (EvaluationContext)subContext);
            if (event.getFlow().is(BaseRewrite.Flow.HANDLED)) break;
            List<Operation> postOperations = subContext.getPostOperations();
            for (int k = 0; k < postOperations.size(); ++k) {
                postOperations.get(k).perform((Rewrite)event, (EvaluationContext)subContext);
            }
            if (event.getFlow().is(BaseRewrite.Flow.HANDLED)) break;
        }
    }

    private boolean handleBindings(HttpServletRewrite event, EvaluationContextImpl context, ParameterValueStoreImpl values) {
        boolean result = true;
        ParameterStore store = (ParameterStore)context.get(ParameterStore.class);
        for (Map.Entry entry : store) {
            String value;
            Parameter parameter = (Parameter)entry.getValue();
            if (Bindings.enqueueSubmission((Rewrite)event, (EvaluationContext)context, (Parameter)parameter, (Object)(value = values.get(parameter)))) continue;
            result = false;
            break;
        }
        return result;
    }

    public List<Operation> getOperations() {
        return Collections.emptyList();
    }

    class EvaluationContextImpl
    extends ContextBase
    implements EvaluationContext {
        private final List<Operation> preOperations = new ArrayList<Operation>();
        private final List<Operation> postOperations = new ArrayList<Operation>();

        public EvaluationContextImpl() {
            this.put(ParameterStore.class, new ParameterStore());
        }

        public void addPreOperation(Operation operation) {
            this.preOperations.add(operation);
        }

        public void addPostOperation(Operation operation) {
            this.preOperations.add(operation);
        }

        public List<Operation> getPreOperations() {
            return Collections.unmodifiableList(this.preOperations);
        }

        public List<Operation> getPostOperations() {
            return Collections.unmodifiableList(this.postOperations);
        }

        public String toString() {
            return "EvaluationContextImpl [preOperations=" + this.preOperations + ", postOperations=" + this.postOperations + "]";
        }

        public void clear() {
            this.postOperations.clear();
            this.postOperations.clear();
        }

        public RewriteState getState() {
            throw new IllegalStateException("not implemented");
        }
    }
}

