/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.bind;

import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.servlet.RewriteWrappedRequest;
import org.ocpsoft.rewrite.servlet.event.ServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.util.Maps;

public abstract class Request
implements Binding {
    public static Request attribute(String property) {
        return new RequestAttributeBinding(property);
    }

    public static Request parameter(String property) {
        return new RequestParameterBinding(property);
    }

    public boolean supportsRetrieval() {
        return true;
    }

    public boolean supportsSubmission() {
        return true;
    }

    private static class RequestAttributeBinding
    extends Request {
        private final String name;

        public RequestAttributeBinding(String attribute) {
            this.name = attribute;
        }

        public Object submit(Rewrite event, EvaluationContext context, Parameter<?> parameter, Object value) {
            ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).setAttribute(this.name, value);
            return null;
        }

        public Object retrieve(Rewrite event, EvaluationContext context, Parameter<?> parameter) {
            if (event instanceof HttpServletRewrite) {
                return ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).getParameter(this.name);
            }
            return null;
        }

        public String toString() {
            return "RequestAttributeBinding [parameter=" + this.name + "]";
        }
    }

    private static class RequestParameterBinding
    extends Request {
        private final String name;

        public RequestParameterBinding(String parameter) {
            this.name = parameter;
        }

        public Object submit(Rewrite event, EvaluationContext context, Parameter<?> parameter, Object value) {
            ServletRequest request = ((ServletRewrite)event).getRequest();
            RewriteWrappedRequest wrapper = RewriteWrappedRequest.getCurrentInstance((ServletRequest)request);
            Map modifiableParameters = wrapper.getModifiableParameters();
            if (value.getClass().isArray()) {
                Object[] values;
                for (Object object : values = (Object[])value) {
                    Maps.addArrayValue((Map)modifiableParameters, (Object)this.name, (String)object.toString());
                }
            } else {
                Maps.addArrayValue((Map)modifiableParameters, (Object)this.name, (String)value.toString());
            }
            return null;
        }

        public Object retrieve(Rewrite event, EvaluationContext context, Parameter<?> parameter) {
            return ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).getParameter(this.name);
        }

        public String toString() {
            return "RequestParameterBinding [parameter=" + this.name + "]";
        }
    }
}

