/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.common.util.Streams;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.servlet.RewriteWrappedResponse;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.config.response.ResponseContentInterceptor;
import org.ocpsoft.rewrite.servlet.config.response.ResponseStreamWrapper;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public abstract class Response
extends HttpOperation {
    public static Response withOutputInterceptedBy(final ResponseContentInterceptor ... buffers) throws IllegalStateException {
        return new Response(){

            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                for (ResponseContentInterceptor buffer : buffers) {
                    RewriteWrappedResponse.getCurrentInstance((ServletRequest)event.getRequest()).addContentInterceptor(buffer);
                }
            }
        };
    }

    public static Response withOutputStreamWrappedBy(final ResponseStreamWrapper ... wrappers) throws IllegalStateException {
        return new Response(){

            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                for (ResponseStreamWrapper wrapper : wrappers) {
                    RewriteWrappedResponse.getCurrentInstance((ServletRequest)event.getRequest()).addStreamWrapper(wrapper);
                }
            }
        };
    }

    public static Response addHeader(final String name, final String value) {
        return new Response(){

            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                ((HttpServletResponse)event.getResponse()).addHeader(name, value);
            }
        };
    }

    public static Response addDateHeader(final String name, final long value) {
        return new Response(){

            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                ((HttpServletResponse)event.getResponse()).addDateHeader(name, value);
            }
        };
    }

    public static Response addIntHeader(final String name, final int value) {
        return new Response(){

            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                ((HttpServletResponse)event.getResponse()).addIntHeader(name, value);
            }
        };
    }

    public static Response addCookie(final Cookie cookie) {
        return new Response(){

            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                ((HttpServletResponse)event.getResponse()).addCookie(cookie);
            }
        };
    }

    public static Response setCode(final int code) {
        return new Response(){

            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                ((HttpServletResponse)event.getResponse()).setStatus(code);
            }
        };
    }

    public static Response write(byte ... bytes) {
        return Response.write(new ByteArrayInputStream(bytes));
    }

    public static Response write(final Object value) {
        return new Response(){

            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                try {
                    if (value != null) {
                        ((HttpServletResponse)event.getResponse()).getWriter().write(value.toString());
                    }
                }
                catch (IOException e) {
                    throw new RewriteException("Could not write value [" + value + "] to response stream.", (Throwable)e);
                }
            }
        };
    }

    public static Response write(final InputStream stream) {
        return new Response(){

            public void performHttp(HttpServletRewrite event, EvaluationContext context) {
                try {
                    Streams.copy((InputStream)stream, (OutputStream)((HttpServletResponse)event.getResponse()).getOutputStream());
                }
                catch (IOException e) {
                    throw new RewriteException("Could not write stream [" + stream + "] to response stream.", (Throwable)e);
                }
            }
        };
    }

    public String toString() {
        return "Response";
    }
}

