/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.rule;

import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.config.DefaultConditionBuilder;
import org.ocpsoft.rewrite.config.Direction;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.ParameterizedPatternParserParameter;
import org.ocpsoft.rewrite.servlet.config.IPath;
import org.ocpsoft.rewrite.servlet.config.Path;
import org.ocpsoft.rewrite.servlet.config.Substitute;
import org.ocpsoft.rewrite.servlet.config.rule.ICDN;
import org.ocpsoft.rewrite.servlet.config.rule.ICDNRelocate;

public class CDN
implements ICDN,
ICDNRelocate {
    private String id;
    private Substitute location;
    private final IPath resource;
    private Operation operation;
    private Condition condition;

    protected CDN(String pattern) {
        this.resource = Path.matches(pattern);
    }

    public static ICDNRelocate relocate(String pattern) {
        return new CDN(pattern);
    }

    @Override
    public ICDN to(String location) {
        this.location = Substitute.with(location);
        return this;
    }

    public boolean evaluate(Rewrite event, EvaluationContext context) {
        if (Direction.isOutbound().evaluate(event, context)) {
            return this.resource.evaluate(event, context);
        }
        return false;
    }

    public void perform(Rewrite event, EvaluationContext context) {
        if (Direction.isOutbound().evaluate(event, context)) {
            this.location.and(this.operation).perform(event, context);
        }
    }

    public ICDN.CDNParameter where(String parameter) {
        return new ICDN.CDNParameter(this, (ParameterizedPatternParserParameter)this.resource.getPathExpression().getParameter(parameter));
    }

    public String getId() {
        return this.id;
    }

    @Override
    public ICDN when(Condition condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public ICDN perform(Operation operation) {
        this.operation = operation;
        return this;
    }

    @Override
    public ICDN withId(String id) {
        this.id = id;
        return this;
    }

    public String toString() {
        return "Join [resource=" + this.resource + ", to=" + this.location + ", id=" + this.id + "]";
    }

    public ConditionBuilder and(Condition condition) {
        return DefaultConditionBuilder.wrap((Condition)this.condition).and(condition);
    }

    public ConditionBuilder andNot(Condition condition) {
        return DefaultConditionBuilder.wrap((Condition)this.condition).andNot(condition);
    }

    public ConditionBuilder or(Condition condition) {
        return DefaultConditionBuilder.wrap((Condition)this.condition).or(condition);
    }

    public ConditionBuilder orNot(Condition condition) {
        return DefaultConditionBuilder.wrap((Condition)this.condition).orNot(condition);
    }

    @Override
    public ParameterizedPatternParser getLocationExpression() {
        return this.location.getTargetExpression();
    }

    @Override
    public ParameterizedPatternParser getResourcExpression() {
        return this.resource.getPathExpression();
    }
}

