/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterBuilder;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilder;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilderParameter;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternBuilder;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.config.IForward;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.util.ParseTools;

public class Forward
extends HttpOperation
implements IForward {
    private final ParameterizedPatternBuilder location;
    private final ParameterStore<IForward.ForwardParameter> parameters = new ParameterStore();

    private Forward(String location) {
        Assert.notNull((Object)location, (String)"Location must not be null.");
        this.location = new RegexParameterizedPatternBuilder(ParseTools.CaptureType.BRACE, "[^/]+", location);
        for (ParameterizedPatternBuilderParameter parameter : this.location.getParameterMap().values()) {
            this.where(parameter.getName()).bindsTo((Binding)Evaluation.property((CharSequence)parameter.getName()));
        }
    }

    public static Forward to(String location) {
        return new Forward(location);
    }

    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            String target = this.location.build((Rewrite)event, context, this.parameters);
            ((HttpInboundServletRewrite)event).forward(target);
        }
    }

    public IForward.ForwardParameter where(String param) {
        return (IForward.ForwardParameter)this.parameters.where(param, (ParameterBuilder)new IForward.ForwardParameter(this, (ParameterizedPatternBuilderParameter)this.location.getParameter(param)));
    }

    public IForward.ForwardParameter where(String param, Binding binding) {
        return (IForward.ForwardParameter)this.where(param).bindsTo(binding);
    }

    public String toString() {
        return this.location.toString();
    }

    @Override
    public ParameterizedPatternBuilder getTargetExpression() {
        return this.location;
    }
}

