/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.redoculous.config.util;

import java.io.File;

/*
 * Exception performing whole class analysis ignored.
 */
public final class OperatingSystemUtils {
    private static boolean PRETEND_WINDOWS = false;
    private static String operatingSystem = null;

    public static String getOsName() {
        if (operatingSystem == null) {
            operatingSystem = System.getProperty("os.name");
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return PRETEND_WINDOWS || OperatingSystemUtils.getOsName().startsWith("Windows") || OperatingSystemUtils.getOsName().startsWith("windows");
    }

    public static boolean isOSX() {
        return OperatingSystemUtils.getOsName().startsWith("Mac") || OperatingSystemUtils.getOsName().startsWith("mac");
    }

    public static boolean isLinux() {
        return OperatingSystemUtils.getOsName().startsWith("Linux") || OperatingSystemUtils.getOsName().startsWith("linux");
    }

    public static File getRedoculousHomeDir() {
        return new File(System.getProperty("redoculous.home")).getAbsoluteFile();
    }

    public static File getUserHomeDir() {
        return new File(System.getProperty("user.home")).getAbsoluteFile();
    }

    public static String getUserHomePath() {
        return OperatingSystemUtils.getUserHomeDir().getAbsolutePath();
    }

    public static File getUserRedoculousDir() {
        return new File(OperatingSystemUtils.getUserHomeDir(), ".redoculous").getAbsoluteFile();
    }

    public static void setPretendWindows(boolean value) {
        PRETEND_WINDOWS = value;
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getSafeFilename(String filename) {
        String result = filename;
        if (result != null) {
            result = result.replaceAll("[/?<>\\\\:*|\"]", "_");
        }
        return result;
    }
}

