/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.redoculous.config.git;

import com.google.gson.Gson;
import com.google.gson.internal.StringMap;
import java.io.File;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.ocpsoft.redoculous.config.util.Files;
import org.ocpsoft.redoculous.config.util.SafeFileNameTransposition;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.param.Transposition;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public final class UpdateRepositoryOperation
extends HttpOperation {
    private final File root;
    Transposition<String> safeFileName = new SafeFileNameTransposition();

    public UpdateRepositoryOperation(File root) {
        this.root = root;
    }

    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        Gson gson = new Gson();
        try {
            String jsonString = ((HttpServletRequest)event.getRequest()).getParameter("payload");
            Map json = (Map)gson.fromJson(jsonString, Map.class);
            StringMap repository = (StringMap)json.get("repository");
            String repo = (String)repository.get((Object)"url");
            if (!repo.endsWith(".git")) {
                repo = repo + ".git";
            }
            String safeRepoName = (String)this.safeFileName.transpose((Rewrite)event, context, (Object)repo);
            File repoDir = new File(this.root, safeRepoName + "/repo");
            File refsDir = new File(this.root, safeRepoName + "/refs");
            File cacheDir = new File(this.root, safeRepoName + "/caches");
            try {
                System.out.println("Handling GitHub web hook update for [" + repo + "]");
                Git git = Git.open((File)repoDir);
                git.fetch().setTagOpt(TagOpt.FETCH_TAGS).setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec("+refs/heads/*:refs/remotes/origin/*")}).setProgressMonitor((ProgressMonitor)new TextProgressMonitor()).call();
                git.fetch().setTagOpt(TagOpt.FETCH_TAGS).setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec("+refs/tags/*:refs/tags/*")}).setProgressMonitor((ProgressMonitor)new TextProgressMonitor()).call();
                git.pull().setRebase(false).setProgressMonitor((ProgressMonitor)new TextProgressMonitor()).call();
                Files.delete((File)refsDir, (boolean)true);
                Files.delete((File)cacheDir, (boolean)true);
                cacheDir.mkdirs();
            }
            catch (GitAPIException e) {
                throw new RewriteException("Could not pull from git repository.", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new RewriteException("Error parsing update hook", (Throwable)e);
        }
    }
}

