/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.redoculous.config.git;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.transport.TagOpt;
import org.ocpsoft.redoculous.config.util.DocumentFilter;
import org.ocpsoft.redoculous.config.util.Files;
import org.ocpsoft.redoculous.config.util.SafeFileNameTransposition;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.Transposition;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public final class CheckoutRefOperation
extends HttpOperation
implements Parameterized {
    Transposition<String> safeFileName = new SafeFileNameTransposition();
    private final File root;
    private String repoParam;
    private String refParam;
    private ParameterStore store;

    public CheckoutRefOperation(File root, String repoParam, String refParam) {
        this.root = root;
        this.repoParam = repoParam;
        this.refParam = refParam;
    }

    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        ParameterValueStore values = (ParameterValueStore)context.get(ParameterValueStore.class);
        String ref = values.retrieve(this.store.get(this.refParam));
        String repo = ((HttpServletRequest)event.getRequest()).getParameter(this.repoParam);
        String safeRepoName = (String)this.safeFileName.transpose((Rewrite)event, context, (Object)repo);
        File repoDir = new File(this.root, safeRepoName + "/repo");
        File refsDir = new File(this.root, safeRepoName + "/refs");
        File cacheDir = new File(this.root, safeRepoName + "/caches");
        File refDir = new File(refsDir, ref);
        File refCacheDir = new File(cacheDir, ref);
        if (!refDir.exists()) {
            System.out.println("Creating ref copy [" + repo + "] [" + ref + "]");
            refDir.mkdirs();
            refCacheDir.mkdirs();
            try {
                Git git = Git.open((File)repoDir);
                ((FetchCommand)git.fetch().setRemote("origin").setTagOpt(TagOpt.FETCH_TAGS).setThin(false).setTimeout(10)).setProgressMonitor((ProgressMonitor)new TextProgressMonitor()).call();
                git.reset().setRef(ref).setMode(ResetCommand.ResetType.HARD).call();
                ((PullCommand)git.pull().setRebase(false).setTimeout(10)).setProgressMonitor((ProgressMonitor)new TextProgressMonitor()).call();
                System.out.println("Deleting cache for [" + repo + "] [" + ref + "]");
                Files.delete((File)refDir, (boolean)true);
                Files.delete((File)refCacheDir, (boolean)true);
                refCacheDir.mkdirs();
                Files.copyDirectory((File)repoDir, (File)refDir, (FileFilter)new DocumentFilter());
            }
            catch (Exception e) {
                Files.delete((File)refDir, (boolean)true);
                Files.delete((File)refCacheDir, (boolean)true);
                throw new RewriteException("Could checkout ref [" + ref + "] from repository [" + repo + "].", (Throwable)e);
            }
        }
    }

    public Set<String> getRequiredParameterNames() {
        return new HashSet<String>(Arrays.asList(this.repoParam, this.refParam));
    }

    public void setParameterStore(ParameterStore store) {
        this.store = store;
    }
}

