/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.property;

import java.text.ParseException;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.ParameterList;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.PeriodList;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.Property;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.PropertyFactoryImpl;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.ValidationException;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.util.ParameterValidator;

public class FreeBusy
extends Property {
    private static final long serialVersionUID = -6415954847619338567L;
    private PeriodList periods;

    public FreeBusy() {
        super("FREEBUSY", PropertyFactoryImpl.getInstance());
        this.periods = new PeriodList();
    }

    public FreeBusy(String aValue) throws ParseException {
        super("FREEBUSY", PropertyFactoryImpl.getInstance());
        this.setValue(aValue);
    }

    public FreeBusy(ParameterList aList, String aValue) throws ParseException {
        super("FREEBUSY", aList, PropertyFactoryImpl.getInstance());
        this.setValue(aValue);
    }

    public FreeBusy(PeriodList pList) {
        super("FREEBUSY", PropertyFactoryImpl.getInstance());
        if (!pList.isUtc()) {
            throw new IllegalArgumentException("Periods must be in UTC format");
        }
        this.periods = pList;
    }

    public FreeBusy(ParameterList aList, PeriodList pList) {
        super("FREEBUSY", aList, PropertyFactoryImpl.getInstance());
        if (!pList.isUtc()) {
            throw new IllegalArgumentException("Periods must be in UTC format");
        }
        this.periods = pList;
    }

    public final void validate() throws ValidationException {
        ParameterValidator.getInstance().assertOneOrLess("FBTYPE", this.getParameters());
        if (!this.periods.isUtc()) {
            throw new ValidationException("Periods must be in UTC format");
        }
    }

    public final PeriodList getPeriods() {
        return this.periods;
    }

    public final void setValue(String aValue) throws ParseException {
        this.periods = new PeriodList(aValue);
    }

    public final String getValue() {
        return this.getPeriods().toString();
    }
}

