/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.com.joestelmach.natty;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.ANTLRNoCaseInputStream;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.DateGroup;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.NattyTokenSource;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.ParseListener;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.ParseLocation;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.generated.DateLexer;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.generated.DateParser;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.generated.DateWalker;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.generated.TreeRewrite;
import org.ocpsoft.prettytime.shade.org.antlr.runtime.CommonTokenStream;
import org.ocpsoft.prettytime.shade.org.antlr.runtime.Token;
import org.ocpsoft.prettytime.shade.org.antlr.runtime.TokenStream;
import org.ocpsoft.prettytime.shade.org.antlr.runtime.tree.CommonTree;
import org.ocpsoft.prettytime.shade.org.antlr.runtime.tree.CommonTreeNodeStream;
import org.ocpsoft.prettytime.shade.org.antlr.runtime.tree.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private TimeZone _defaultTimeZone;
    private static final Logger _logger = Logger.getLogger("org.ocpsoft.prettytime.shade.com.joestelmach.natty");

    public Parser(TimeZone defaultTimeZone) {
        this._defaultTimeZone = defaultTimeZone;
    }

    public Parser() {
        this._defaultTimeZone = TimeZone.getDefault();
    }

    public List<DateGroup> parse(String value) {
        ANTLRNoCaseInputStream input = null;
        try {
            input = new ANTLRNoCaseInputStream(new ByteArrayInputStream(value.trim().getBytes()));
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "could not lex input", e);
        }
        DateLexer lexer = new DateLexer(input);
        List<TokenStream> streams = this.collectTokenStreams(new CommonTokenStream(lexer));
        ArrayList<DateGroup> groups = new ArrayList<DateGroup>();
        for (TokenStream stream : streams) {
            List<Token> tokens = ((NattyTokenSource)stream.getTokenSource()).getTokens();
            DateGroup group = this.singleParse(stream);
            while ((group == null || group.getDates().size() == 0) && tokens.size() > 0) {
                Token token;
                if (group != null && group.getDates().size() != 0) continue;
                if (tokens.size() <= 2) {
                    tokens.clear();
                    continue;
                }
                tokens = tokens.subList(2, tokens.size());
                Iterator<Token> iter = tokens.iterator();
                while (iter.hasNext() && !DateParser.FOLLOW_empty_in_parse181.member((token = iter.next()).getType())) {
                    iter.remove();
                }
                this.cleanupGroup(tokens);
                CommonTokenStream newStream = new CommonTokenStream(new NattyTokenSource(tokens));
                group = this.singleParse(newStream);
            }
            if (group == null || group.getDates().size() <= 0) continue;
            groups.add(group);
        }
        return groups;
    }

    private DateGroup singleParse(TokenStream stream) {
        StringBuilder tokenString = new StringBuilder();
        for (Token token : ((NattyTokenSource)stream.getTokenSource()).getTokens()) {
            tokenString.append(DateParser.tokenNames[token.getType()]);
            tokenString.append(" ");
        }
        _logger.fine("sub-token stream: " + tokenString.toString());
        DateGroup group = null;
        try {
            ParseListener listener = new ParseListener();
            DateParser parser = new DateParser(stream, listener);
            DateParser.parse_return parseReturn = parser.parse();
            Tree tree = (Tree)parseReturn.getTree();
            _logger.fine("AST: " + tree.toStringTree());
            if (tree.getChildCount() > 0) {
                CommonTreeNodeStream nodes = new CommonTreeNodeStream(tree);
                TreeRewrite s = new TreeRewrite(nodes);
                tree = (CommonTree)s.downup(tree);
                nodes = new CommonTreeNodeStream(tree);
                nodes.setTokenStream(stream);
                DateWalker walker = new DateWalker(nodes);
                walker.getState().setDefaultTimeZone(this._defaultTimeZone);
                walker.parse();
                group = walker.getState().getDateGroup();
                ParseLocation location = listener.getDateGroupLocation();
                group.setLine(location.getLine());
                group.setText(location.getText());
                group.setPosition(location.getStart());
                group.setSyntaxTree(tree);
                group.setParseLocations(listener.getLocations());
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "Could not parse input", e);
        }
        return group;
    }

    private List<TokenStream> collectTokenStreams(TokenStream stream) {
        Token currentToken;
        ArrayList<Token> currentGroup = null;
        ArrayList<TokenStream> groups = new ArrayList<TokenStream>();
        StringBuilder tokenString = new StringBuilder();
        while ((currentToken = stream.getTokenSource().nextToken()).getType() != -1) {
            if (_logger.getLevel() != null && _logger.getLevel().intValue() <= Level.FINE.intValue()) {
                tokenString.append(DateParser.tokenNames[currentToken.getType()]);
                tokenString.append(" ");
            }
            if (currentGroup == null) {
                if (currentToken.getType() == 241 || !DateParser.FOLLOW_empty_in_parse181.member(currentToken.getType())) continue;
                currentGroup = new ArrayList<Token>();
                currentGroup.add(currentToken);
                continue;
            }
            if (currentToken.getType() == 241) {
                currentGroup.add(currentToken);
                continue;
            }
            if (currentToken.getType() == 274) {
                if (currentGroup.size() > 0) {
                    this.cleanupGroup(currentGroup);
                    groups.add(new CommonTokenStream(new NattyTokenSource(currentGroup)));
                }
                currentGroup = null;
                continue;
            }
            if (currentToken.getType() == 4) continue;
            currentGroup.add(currentToken);
        }
        if (currentGroup != null) {
            this.cleanupGroup(currentGroup);
            groups.add(new CommonTokenStream(new NattyTokenSource((List<Token>)currentGroup)));
        }
        _logger.fine("global token stream: " + tokenString.toString());
        return groups;
    }

    private void cleanupGroup(List<Token> group) {
        Token lastToken;
        Token firstToken;
        Iterator<Token> iter = group.iterator();
        Token previousToken = null;
        while (iter.hasNext()) {
            Token token = iter.next();
            if (previousToken != null && previousToken.getType() == 241 && token.getType() == 241) {
                iter.remove();
            }
            previousToken = token;
        }
        if (group.size() > 0 && (firstToken = group.get(0)).getType() == 241) {
            group.remove(firstToken);
        }
        if (group.size() > 0 && (lastToken = group.get(group.size() - 1)).getType() == 241) {
            group.remove(lastToken);
        }
    }
}

