/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.subscription.mongodb.internal;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.OperationType;
import io.cloudevents.CloudEvent;
import java.util.Optional;
import org.bson.Document;
import org.occurrent.eventstore.mongodb.internal.OccurrentCloudEventMongoDocumentMapper;
import org.occurrent.mongodb.timerepresentation.TimeRepresentation;

public class MongoCloudEventsToJsonDeserializer {
    public static final String ID = "_id";

    public static Optional<CloudEvent> deserializeToCloudEvent(ChangeStreamDocument<Document> changeStreamDocument, TimeRepresentation timeRepresentation) {
        return MongoCloudEventsToJsonDeserializer.changeStreamDocumentToCloudEventAsJson(changeStreamDocument).map(document -> OccurrentCloudEventMongoDocumentMapper.convertToCloudEvent((TimeRepresentation)timeRepresentation, (Document)document));
    }

    private static Optional<Document> changeStreamDocumentToCloudEventAsJson(ChangeStreamDocument<Document> changeStreamDocument) {
        OperationType operationType = changeStreamDocument.getOperationType();
        Document eventsAsJson = operationType == OperationType.INSERT ? (Document)changeStreamDocument.getFullDocument() : null;
        return Optional.ofNullable(eventsAsJson);
    }
}

