/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.subscription.mongodb;

import com.mongodb.client.model.Aggregates;
import java.util.function.BiFunction;
import org.bson.conversions.Bson;
import org.occurrent.subscription.SubscriptionFilter;

public class MongoFilterSpecification
implements SubscriptionFilter {
    public static final String FULL_DOCUMENT = "fullDocument";

    public static class MongoBsonFilterSpecification
    extends MongoFilterSpecification {
        private final Bson[] aggregationStages;

        private MongoBsonFilterSpecification() {
            this.aggregationStages = new Bson[0];
        }

        public MongoBsonFilterSpecification(Bson firstAggregationStage, Bson ... additionalStages) {
            this(new Bson[]{firstAggregationStage}, additionalStages);
        }

        private MongoBsonFilterSpecification(Bson[] firstAggregationStage, Bson ... additionalStages) {
            this.aggregationStages = new Bson[firstAggregationStage.length + additionalStages.length];
            System.arraycopy(firstAggregationStage, 0, this.aggregationStages, 0, firstAggregationStage.length);
            System.arraycopy(additionalStages, 0, this.aggregationStages, firstAggregationStage.length, additionalStages.length);
        }

        public static MongoBsonFilterSpecification filter(Bson firstAggregationStage, Bson ... additionalStages) {
            return new MongoBsonFilterSpecification(firstAggregationStage, additionalStages);
        }

        public static MongoBsonFilterSpecification filter() {
            return new MongoBsonFilterSpecification();
        }

        public MongoBsonFilterSpecification and() {
            return this;
        }

        public MongoBsonFilterSpecification id(BiFunction<String, String, Bson> filter, String value) {
            return new MongoBsonFilterSpecification(this.aggregationStages, MongoBsonFilterSpecification.matchStage(filter, "id", value));
        }

        public MongoBsonFilterSpecification type(BiFunction<String, String, Bson> filter, String value) {
            return new MongoBsonFilterSpecification(this.aggregationStages, MongoBsonFilterSpecification.matchStage(filter, "type", value));
        }

        public MongoBsonFilterSpecification source(BiFunction<String, String, Bson> filter, String value) {
            return new MongoBsonFilterSpecification(this.aggregationStages, MongoBsonFilterSpecification.matchStage(filter, "source", value));
        }

        public MongoBsonFilterSpecification subject(BiFunction<String, String, Bson> filter, String value) {
            return new MongoBsonFilterSpecification(this.aggregationStages, MongoBsonFilterSpecification.matchStage(filter, "subject", value));
        }

        public MongoBsonFilterSpecification dataSchema(BiFunction<String, String, Bson> filter, String value) {
            return new MongoBsonFilterSpecification(this.aggregationStages, MongoBsonFilterSpecification.matchStage(filter, "dataschema", value));
        }

        public MongoBsonFilterSpecification specVersion(BiFunction<String, String, Bson> filter, String value) {
            return new MongoBsonFilterSpecification(this.aggregationStages, MongoBsonFilterSpecification.matchStage(filter, "specversion", value));
        }

        public MongoBsonFilterSpecification dataContentType(BiFunction<String, String, Bson> filter, String value) {
            return new MongoBsonFilterSpecification(this.aggregationStages, MongoBsonFilterSpecification.matchStage(filter, "datacontenttype", value));
        }

        public MongoBsonFilterSpecification time(BiFunction<String, String, Bson> filter, String value) {
            return new MongoBsonFilterSpecification(this.aggregationStages, MongoBsonFilterSpecification.matchStage(filter, "time", value));
        }

        public MongoBsonFilterSpecification occurrentStreamId(BiFunction<String, String, Bson> filter, String value) {
            return new MongoBsonFilterSpecification(this.aggregationStages, MongoBsonFilterSpecification.matchStage(filter, "occurrentStreamId", value));
        }

        public MongoBsonFilterSpecification extension(BiFunction<String, String, Bson> filter, String propertyName, String value) {
            return new MongoBsonFilterSpecification(this.aggregationStages, MongoBsonFilterSpecification.matchStage(filter, propertyName, value));
        }

        public MongoBsonFilterSpecification data(BiFunction<String, String, Bson> filter, String propertyName, String value) {
            return new MongoBsonFilterSpecification(this.aggregationStages, MongoBsonFilterSpecification.matchStage(filter, "data." + propertyName, value));
        }

        private static Bson matchStage(BiFunction<String, String, Bson> filter, String propertyName, String value) {
            return Aggregates.match((Bson)filter.apply("fullDocument." + propertyName, value));
        }

        public Bson[] getAggregationStages() {
            return this.aggregationStages;
        }
    }

    public static class MongoJsonFilterSpecification
    extends MongoFilterSpecification {
        private final String json;

        public MongoJsonFilterSpecification(String json) {
            this.json = json;
        }

        public String getJson() {
            return this.json;
        }

        public static MongoJsonFilterSpecification filter(String json) {
            return new MongoJsonFilterSpecification(json);
        }
    }
}

