/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.example.domain.uno.es;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import io.cloudevents.CloudEvent;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.occurrent.application.composition.command.PartialExtensionsKt;
import org.occurrent.application.converter.CloudEventConverter;
import org.occurrent.application.service.blocking.ApplicationService;
import org.occurrent.application.service.blocking.ApplicationServiceExtensionsKt;
import org.occurrent.application.service.blocking.generic.GenericApplicationService;
import org.occurrent.eventstore.api.blocking.EventStore;
import org.occurrent.eventstore.mongodb.nativedriver.EventStoreConfig;
import org.occurrent.eventstore.mongodb.nativedriver.MongoEventStore;
import org.occurrent.example.domain.uno.Card;
import org.occurrent.example.domain.uno.CardPlayed;
import org.occurrent.example.domain.uno.Color;
import org.occurrent.example.domain.uno.Digit;
import org.occurrent.example.domain.uno.Event;
import org.occurrent.example.domain.uno.ProgressTracker;
import org.occurrent.example.domain.uno.Uno;
import org.occurrent.example.domain.uno.es.UnoCloudEventConverter;
import org.occurrent.example.domain.uno.es.UnoCloudEventConverterKt;
import org.occurrent.filter.Filter;
import org.occurrent.mongodb.timerepresentation.TimeRepresentation;
import org.occurrent.retry.RetryStrategy;
import org.occurrent.subscription.mongodb.nativedriver.blocking.NativeMongoSubscriptionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u0006\u0010\u0003\u001a\u00020\u0004\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "main", "", "example-uno-es-mongodb-native"})
public final class EventSourcedUnoKt {
    private static final Logger log = LoggerFactory.getLogger((String)"org.occurrent.example.domain.uno.es");

    public static final void main() {
        log.info("Starting UNO application");
        MongoClient mongoClient = MongoClients.create((String)"mongodb://localhost:27017");
        Intrinsics.checkNotNullExpressionValue((Object)mongoClient, (String)"MongoClients.create(\"mongodb://localhost:27017\")");
        MongoClient mongoClient2 = mongoClient;
        MongoDatabase mongoDatabase = mongoClient2.getDatabase("test");
        Intrinsics.checkNotNullExpressionValue((Object)mongoDatabase, (String)"mongoClient.getDatabase(\"test\")");
        MongoDatabase database = mongoDatabase;
        MongoEventStore eventStore = new MongoEventStore(mongoClient2, database, database.getCollection("events"), new EventStoreConfig(TimeRepresentation.DATE));
        NativeMongoSubscriptionModel subscriptionModel = new NativeMongoSubscriptionModel(database, "events", TimeRepresentation.DATE, Executors.newCachedThreadPool(), (RetryStrategy)RetryStrategy.fixed((long)200L));
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();
        UnoCloudEventConverter cloudEventConverter = new UnoCloudEventConverter(objectMapper);
        GenericApplicationService applicationService = new GenericApplicationService((EventStore)eventStore, (CloudEventConverter)cloudEventConverter);
        subscriptionModel.subscribe("progress-tracker", (Consumer)new Consumer<CloudEvent>(cloudEventConverter, eventStore){
            final /* synthetic */ UnoCloudEventConverter $cloudEventConverter;
            final /* synthetic */ MongoEventStore $eventStore;

            public final void accept(CloudEvent cloudEvent) {
                CloudEvent cloudEvent2 = cloudEvent;
                Intrinsics.checkNotNullExpressionValue((Object)cloudEvent2, (String)"cloudEvent");
                Event domainEvent = this.$cloudEventConverter.toDomainEvent(cloudEvent2);
                int turnCount = (int)this.$eventStore.count(Filter.streamId((String)domainEvent.getGameId().toString()).and(Filter.type((String)UnoCloudEventConverterKt.getType((KClass)Reflection.getOrCreateKotlinClass(CardPlayed.class))), new Filter[0]));
                ProgressTracker.INSTANCE.trackProgress((Function1)new Function1<String, Unit>(EventSourcedUnoKt.access$getLog$p()){

                    public final void invoke(String p1) {
                        ((Logger)this.receiver).info(p1);
                    }
                }, domainEvent, turnCount);
            }
            {
                this.$cloudEventConverter = unoCloudEventConverter;
                this.$eventStore = mongoEventStore;
            }
        }).waitUntilStarted();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(subscriptionModel, mongoClient2){
            final /* synthetic */ NativeMongoSubscriptionModel $subscriptionModel;
            final /* synthetic */ MongoClient $mongoClient;

            public final void run() {
                EventSourcedUnoKt.access$getLog$p().info("Shutting down");
                this.$subscriptionModel.shutdown();
                this.$mongoClient.close();
            }
            {
                this.$subscriptionModel = nativeMongoSubscriptionModel;
                this.$mongoClient = mongoClient;
            }
        }));
        UUID gameId = UUID.randomUUID();
        List commands2 = CollectionsKt.listOf((Object[])new Function1[]{PartialExtensionsKt.partial((Function5)((Function5)new Function5<Sequence<? extends Event>, UUID, LocalDateTime, Integer, Card, Sequence<? extends Event>>(Uno.INSTANCE){

            @NotNull
            public final Sequence<Event> invoke(@NotNull Sequence<? extends Event> p1, @NotNull UUID p2, @NotNull LocalDateTime p3, int p4, @NotNull Card p5) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                Intrinsics.checkNotNullParameter((Object)p5, (String)"p5");
                return ((Uno)this.receiver).start(p1, p2, p3, p4, p5);
            }
        }), (Object)gameId, (Object)LocalDateTime.now(), (Object)4, (Object)new Card.DigitCard((Digit)Digit.Three.INSTANCE, (Color)Color.Red.INSTANCE)), PartialExtensionsKt.partial((Function4)((Function4)new Function4<Sequence<? extends Event>, LocalDateTime, Integer, Card, Sequence<? extends Event>>(Uno.INSTANCE){

            @NotNull
            public final Sequence<Event> invoke(@NotNull Sequence<? extends Event> p1, @NotNull LocalDateTime p2, int p3, @NotNull Card p4) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)p4, (String)"p4");
                return ((Uno)this.receiver).play(p1, p2, p3, p4);
            }
        }), (Object)LocalDateTime.now(), (Object)0, (Object)new Card.DigitCard((Digit)Digit.Three.INSTANCE, (Color)Color.Blue.INSTANCE)), PartialExtensionsKt.partial((Function4)((Function4)new Function4<Sequence<? extends Event>, LocalDateTime, Integer, Card, Sequence<? extends Event>>(Uno.INSTANCE){

            @NotNull
            public final Sequence<Event> invoke(@NotNull Sequence<? extends Event> p1, @NotNull LocalDateTime p2, int p3, @NotNull Card p4) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)p4, (String)"p4");
                return ((Uno)this.receiver).play(p1, p2, p3, p4);
            }
        }), (Object)LocalDateTime.now(), (Object)1, (Object)new Card.DigitCard((Digit)Digit.Eight.INSTANCE, (Color)Color.Blue.INSTANCE)), PartialExtensionsKt.partial((Function4)((Function4)new Function4<Sequence<? extends Event>, LocalDateTime, Integer, Card, Sequence<? extends Event>>(Uno.INSTANCE){

            @NotNull
            public final Sequence<Event> invoke(@NotNull Sequence<? extends Event> p1, @NotNull LocalDateTime p2, int p3, @NotNull Card p4) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)p4, (String)"p4");
                return ((Uno)this.receiver).play(p1, p2, p3, p4);
            }
        }), (Object)LocalDateTime.now(), (Object)2, (Object)new Card.DigitCard((Digit)Digit.Eight.INSTANCE, (Color)Color.Yellow.INSTANCE)), PartialExtensionsKt.partial((Function4)((Function4)new Function4<Sequence<? extends Event>, LocalDateTime, Integer, Card, Sequence<? extends Event>>(Uno.INSTANCE){

            @NotNull
            public final Sequence<Event> invoke(@NotNull Sequence<? extends Event> p1, @NotNull LocalDateTime p2, int p3, @NotNull Card p4) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)p4, (String)"p4");
                return ((Uno)this.receiver).play(p1, p2, p3, p4);
            }
        }), (Object)LocalDateTime.now(), (Object)0, (Object)new Card.DigitCard((Digit)Digit.Four.INSTANCE, (Color)Color.Green.INSTANCE))});
        Iterable $this$forEach$iv = commands2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 command = (Function1)element$iv;
            boolean bl = false;
            ApplicationService applicationService2 = (ApplicationService)applicationService;
            UUID uUID = gameId;
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"gameId");
            ApplicationServiceExtensionsKt.execute((ApplicationService)applicationService2, (UUID)uUID, (Function1)command);
        }
        Thread.sleep(1000L);
        int n = 0;
        boolean bl = false;
        System.exit(n);
        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    public static /* synthetic */ void main(String[] stringArray) {
        EventSourcedUnoKt.main();
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return log;
    }
}

