/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.example.domain.uno.es;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import io.cloudevents.CloudEvent;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.occurrent.application.composition.command.PartialExtensionsKt;
import org.occurrent.application.converter.CloudEventConverter;
import org.occurrent.application.service.blocking.ApplicationService;
import org.occurrent.application.service.blocking.ApplicationServiceExtensionsKt;
import org.occurrent.application.service.blocking.generic.GenericApplicationService;
import org.occurrent.eventstore.api.blocking.EventStore;
import org.occurrent.eventstore.mongodb.nativedriver.EventStoreConfig;
import org.occurrent.eventstore.mongodb.nativedriver.MongoEventStore;
import org.occurrent.example.domain.uno.Card;
import org.occurrent.example.domain.uno.CardPlayed;
import org.occurrent.example.domain.uno.Color;
import org.occurrent.example.domain.uno.Digit;
import org.occurrent.example.domain.uno.Event;
import org.occurrent.example.domain.uno.ProgressTracker;
import org.occurrent.example.domain.uno.Uno;
import org.occurrent.example.domain.uno.es.UnoCloudEventConverter;
import org.occurrent.example.domain.uno.es.UnoCloudEventConverterKt;
import org.occurrent.filter.Filter;
import org.occurrent.mongodb.timerepresentation.TimeRepresentation;
import org.occurrent.retry.RetryStrategy;
import org.occurrent.subscription.mongodb.nativedriver.blocking.NativeMongoSubscriptionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u0006\u0010\u0003\u001a\u00020\u0004\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "main", "", "example-uno-es-mongodb-native"})
@SourceDebugExtension(value={"SMAP\nEventSourcedUno.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventSourcedUno.kt\norg/occurrent/example/domain/uno/es/EventSourcedUnoKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1855#2,2:86\n*S KotlinDebug\n*F\n+ 1 EventSourcedUno.kt\norg/occurrent/example/domain/uno/es/EventSourcedUnoKt\n*L\n79#1:86,2\n*E\n"})
public final class EventSourcedUnoKt {
    private static final Logger log = LoggerFactory.getLogger((String)"org.occurrent.example.domain.uno.es");

    public static final void main() {
        log.info("Starting UNO application");
        MongoClient mongoClient = MongoClients.create((String)"mongodb://localhost:27017");
        Intrinsics.checkNotNullExpressionValue((Object)mongoClient, (String)"create(...)");
        MongoClient mongoClient2 = mongoClient;
        MongoDatabase mongoDatabase = mongoClient2.getDatabase("test");
        Intrinsics.checkNotNullExpressionValue((Object)mongoDatabase, (String)"getDatabase(...)");
        MongoDatabase database = mongoDatabase;
        MongoEventStore eventStore = new MongoEventStore(mongoClient2, database, database.getCollection("events"), new EventStoreConfig(TimeRepresentation.DATE));
        NativeMongoSubscriptionModel subscriptionModel = new NativeMongoSubscriptionModel(database, "events", TimeRepresentation.DATE, Executors.newCachedThreadPool(), (RetryStrategy)RetryStrategy.fixed((long)200L));
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();
        UnoCloudEventConverter cloudEventConverter = new UnoCloudEventConverter(objectMapper);
        GenericApplicationService applicationService = new GenericApplicationService((EventStore)eventStore, (CloudEventConverter)cloudEventConverter);
        subscriptionModel.subscribe("progress-tracker", arg_0 -> EventSourcedUnoKt.main$lambda$0(cloudEventConverter, eventStore, arg_0)).waitUntilStarted();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> EventSourcedUnoKt.main$lambda$1(subscriptionModel, mongoClient2)));
        UUID gameId = UUID.randomUUID();
        Object[] objectArray = new Function1[]{PartialExtensionsKt.partial((Function5)((Function5)new Function5<Sequence<? extends Event>, UUID, LocalDateTime, Integer, Card, Sequence<? extends Event>>((Object)Uno.INSTANCE){

            @NotNull
            public final Sequence<Event> invoke(@NotNull Sequence<? extends Event> p0, @NotNull UUID p1, @NotNull LocalDateTime p2, int p3, @NotNull Card p4) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)p4, (String)"p4");
                return ((Uno)this.receiver).start(p0, p1, p2, p3, p4);
            }
        }), (Object)gameId, (Object)LocalDateTime.now(), (Object)4, (Object)new Card.DigitCard((Digit)Digit.Three.INSTANCE, (Color)Color.Red.INSTANCE)), PartialExtensionsKt.partial((Function4)((Function4)new Function4<Sequence<? extends Event>, LocalDateTime, Integer, Card, Sequence<? extends Event>>((Object)Uno.INSTANCE){

            @NotNull
            public final Sequence<Event> invoke(@NotNull Sequence<? extends Event> p0, @NotNull LocalDateTime p1, int p2, @NotNull Card p3) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                return ((Uno)this.receiver).play(p0, p1, p2, p3);
            }
        }), (Object)LocalDateTime.now(), (Object)0, (Object)new Card.DigitCard((Digit)Digit.Three.INSTANCE, (Color)Color.Blue.INSTANCE)), PartialExtensionsKt.partial((Function4)((Function4)new Function4<Sequence<? extends Event>, LocalDateTime, Integer, Card, Sequence<? extends Event>>((Object)Uno.INSTANCE){

            @NotNull
            public final Sequence<Event> invoke(@NotNull Sequence<? extends Event> p0, @NotNull LocalDateTime p1, int p2, @NotNull Card p3) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                return ((Uno)this.receiver).play(p0, p1, p2, p3);
            }
        }), (Object)LocalDateTime.now(), (Object)1, (Object)new Card.DigitCard((Digit)Digit.Eight.INSTANCE, (Color)Color.Blue.INSTANCE)), PartialExtensionsKt.partial((Function4)((Function4)new Function4<Sequence<? extends Event>, LocalDateTime, Integer, Card, Sequence<? extends Event>>((Object)Uno.INSTANCE){

            @NotNull
            public final Sequence<Event> invoke(@NotNull Sequence<? extends Event> p0, @NotNull LocalDateTime p1, int p2, @NotNull Card p3) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                return ((Uno)this.receiver).play(p0, p1, p2, p3);
            }
        }), (Object)LocalDateTime.now(), (Object)2, (Object)new Card.DigitCard((Digit)Digit.Eight.INSTANCE, (Color)Color.Yellow.INSTANCE)), PartialExtensionsKt.partial((Function4)((Function4)new Function4<Sequence<? extends Event>, LocalDateTime, Integer, Card, Sequence<? extends Event>>((Object)Uno.INSTANCE){

            @NotNull
            public final Sequence<Event> invoke(@NotNull Sequence<? extends Event> p0, @NotNull LocalDateTime p1, int p2, @NotNull Card p3) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                return ((Uno)this.receiver).play(p0, p1, p2, p3);
            }
        }), (Object)LocalDateTime.now(), (Object)0, (Object)new Card.DigitCard((Digit)Digit.Four.INSTANCE, (Color)Color.Green.INSTANCE))};
        List commands2 = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = commands2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 command = (Function1)element$iv;
            boolean bl = false;
            ApplicationService applicationService2 = (ApplicationService)applicationService;
            Intrinsics.checkNotNull((Object)gameId);
            ApplicationServiceExtensionsKt.execute((ApplicationService)applicationService2, (UUID)gameId, (Function1)command);
        }
        Thread.sleep(1000L);
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    public static /* synthetic */ void main(String[] args) {
        EventSourcedUnoKt.main();
    }

    private static final void main$lambda$0(UnoCloudEventConverter $cloudEventConverter, MongoEventStore $eventStore, CloudEvent cloudEvent) {
        Intrinsics.checkNotNullParameter((Object)$cloudEventConverter, (String)"$cloudEventConverter");
        Intrinsics.checkNotNullParameter((Object)$eventStore, (String)"$eventStore");
        Intrinsics.checkNotNull((Object)cloudEvent);
        Event domainEvent = $cloudEventConverter.toDomainEvent(cloudEvent);
        int turnCount = (int)$eventStore.count(Filter.streamId((String)domainEvent.getGameId().toString()).and(Filter.type((String)UnoCloudEventConverterKt.getType((KClass)Reflection.getOrCreateKotlinClass(CardPlayed.class))), new Filter[0]));
        Logger logger = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        ProgressTracker.INSTANCE.trackProgress((Function1)new Function1<String, Unit>((Object)logger){

            public final void invoke(String p0) {
                ((Logger)this.receiver).info(p0);
            }
        }, domainEvent, turnCount);
    }

    private static final void main$lambda$1(NativeMongoSubscriptionModel $subscriptionModel, MongoClient $mongoClient) {
        Intrinsics.checkNotNullParameter((Object)$subscriptionModel, (String)"$subscriptionModel");
        Intrinsics.checkNotNullParameter((Object)$mongoClient, (String)"$mongoClient");
        log.info("Shutting down");
        $subscriptionModel.shutdown();
        $mongoClient.close();
    }
}

