/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.example.domain.rps.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.occurrent.example.domain.rps.model.DomainState;
import org.occurrent.example.domain.rps.model.Hand;
import org.occurrent.example.domain.rps.model.Round;
import org.occurrent.example.domain.rps.model.StateEvolution;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002J\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u00a8\u0006\t"}, d2={"Lorg/occurrent/example/domain/rps/model/StateTranslation;", "", "()V", "toDomain", "Lorg/occurrent/example/domain/rps/model/Round;", "Lorg/occurrent/example/domain/rps/model/StateEvolution$EvolvedRound;", "translateToDomain", "Lorg/occurrent/example/domain/rps/model/DomainState;", "Lorg/occurrent/example/domain/rps/model/StateEvolution$EvolvedState;", "example-rps-model"})
final class StateTranslation {
    @NotNull
    public static final StateTranslation INSTANCE = new StateTranslation();

    private StateTranslation() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DomainState translateToDomain(@NotNull StateEvolution.EvolvedState $this$translateToDomain) {
        DomainState domainState;
        Intrinsics.checkNotNullParameter((Object)$this$translateToDomain, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$translateToDomain.getState().ordinal()]) {
            case 1: {
                domainState = new DomainState.Created($this$translateToDomain.getGameId-tte2sNk(), $this$translateToDomain.getBestOfRounds-esUtRFY(), null);
                break;
            }
            case 2: {
                domainState = new DomainState.Started($this$translateToDomain.getGameId-tte2sNk(), $this$translateToDomain.getBestOfRounds-esUtRFY(), this.toDomain((StateEvolution.EvolvedRound)CollectionsKt.first((List)((List)$this$translateToDomain.getRounds()))), null);
                break;
            }
            case 3: {
                UUID uUID = $this$translateToDomain.getGameId-tte2sNk();
                int n = $this$translateToDomain.getBestOfRounds-esUtRFY();
                UUID uUID2 = $this$translateToDomain.getFirstPlayer-4gH-g70();
                Intrinsics.checkNotNull((Object)uUID2);
                domainState = new DomainState.FirstPlayerJoined(uUID, n, uUID2, this.toDomain((StateEvolution.EvolvedRound)CollectionsKt.first((List)((List)$this$translateToDomain.getRounds()))), null);
                break;
            }
            case 4: {
                Collection<Round> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                UUID uUID = $this$translateToDomain.getGameId-tte2sNk();
                int n = $this$translateToDomain.getBestOfRounds-esUtRFY();
                UUID uUID3 = $this$translateToDomain.getFirstPlayer-4gH-g70();
                Intrinsics.checkNotNull((Object)uUID3);
                UUID uUID4 = $this$translateToDomain.getSecondPlayer-4gH-g70();
                Intrinsics.checkNotNull((Object)uUID4);
                Iterable iterable = (Iterable)$this$translateToDomain.getRounds();
                UUID uUID5 = uUID4;
                UUID uUID6 = uUID3;
                int n2 = n;
                UUID uUID7 = uUID;
                boolean $i$f$map = false;
                void var4_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void round;
                    StateEvolution.EvolvedRound evolvedRound = (StateEvolution.EvolvedRound)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(INSTANCE.toDomain((StateEvolution.EvolvedRound)round));
                }
                collection = (List)destination$iv$iv;
                DefaultConstructorMarker defaultConstructorMarker = null;
                PersistentList persistentList = ExtensionsKt.toPersistentList((Iterable)collection);
                UUID uUID8 = uUID5;
                UUID uUID9 = uUID6;
                int n3 = n2;
                UUID uUID10 = uUID7;
                domainState = new DomainState.BothPlayersJoined(uUID10, n3, uUID9, uUID8, persistentList, defaultConstructorMarker);
                break;
            }
            case 5: {
                domainState = new DomainState.Ended($this$translateToDomain.getGameId-tte2sNk(), $this$translateToDomain.getBestOfRounds-esUtRFY(), null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return domainState;
    }

    private final Round toDomain(StateEvolution.EvolvedRound $this$toDomain) {
        Round round;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toDomain.getState().ordinal()]) {
            case 1: {
                Round.Ongoing ongoing;
                switch ($this$toDomain.getHands().size()) {
                    case 0: {
                        ongoing = new Round.WaitingForFirstHand($this$toDomain.getRoundNumber-W45pMc4(), null);
                        break;
                    }
                    case 1: {
                        ongoing = new Round.WaitingForSecondHand($this$toDomain.getRoundNumber-W45pMc4(), (Hand)$this$toDomain.getHands().get(0), null);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Cannot play more than two hands in a round");
                    }
                }
                round = ongoing;
                break;
            }
            case 2: {
                round = new Round.Tied($this$toDomain.getRoundNumber-W45pMc4(), (Hand)$this$toDomain.getHands().get(0), (Hand)$this$toDomain.getHands().get(1), null);
                break;
            }
            case 3: {
                int n = $this$toDomain.getRoundNumber-W45pMc4();
                Hand hand = (Hand)$this$toDomain.getHands().get(0);
                Hand hand2 = (Hand)$this$toDomain.getHands().get(1);
                UUID uUID = $this$toDomain.getWinner-4gH-g70();
                Intrinsics.checkNotNull((Object)uUID);
                round = new Round.Won(n, hand, hand2, uUID, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return round;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[StateEvolution.EvolvedGameState.values().length];
            nArray[StateEvolution.EvolvedGameState.Created.ordinal()] = 1;
            nArray[StateEvolution.EvolvedGameState.Started.ordinal()] = 2;
            nArray[StateEvolution.EvolvedGameState.FirstPlayerJoined.ordinal()] = 3;
            nArray[StateEvolution.EvolvedGameState.BothPlayersJoined.ordinal()] = 4;
            nArray[StateEvolution.EvolvedGameState.Ended.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[StateEvolution.EvolvedRound.RoundState.values().length];
            nArray[StateEvolution.EvolvedRound.RoundState.Ongoing.ordinal()] = 1;
            nArray[StateEvolution.EvolvedRound.RoundState.Tied.ordinal()] = 2;
            nArray[StateEvolution.EvolvedRound.RoundState.Won.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

