/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.example.domain.rps.model;

import java.time.ZonedDateTime;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.occurrent.example.domain.rps.model.AccumulatedChanges;
import org.occurrent.example.domain.rps.model.GameCannotBeCreatedMoreThanOnce;
import org.occurrent.example.domain.rps.model.GameCreated;
import org.occurrent.example.domain.rps.model.GameDoesNotExist;
import org.occurrent.example.domain.rps.model.GameEvent;
import org.occurrent.example.domain.rps.model.GameLogic;
import org.occurrent.example.domain.rps.model.StateEvolution;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001aC\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\b*\u0014\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u000b\u001a\u0002H\tH\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"handle", "Lkotlin/sequences/Sequence;", "Lorg/occurrent/example/domain/rps/model/GameEvent;", "events", "cmd", "LGameCommand;", "partial", "Lkotlin/Function1;", "B", "A", "Lkotlin/Function2;", "a", "(Lkotlin/jvm/functions/Function2;Ljava/lang/Object;)Lkotlin/jvm/functions/Function1;", "example-rps-model"})
public final class BehaviorKt {
    @NotNull
    public static final Sequence<GameEvent> handle(@NotNull Sequence<? extends GameEvent> events, @NotNull GameCommand cmd) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        StateEvolution.EvolvedState state = StateEvolution.evolve$default(StateEvolution.INSTANCE, events, null, 1, null);
        GameCommand gameCommand = cmd;
        if (gameCommand instanceof CreateGame) {
            if (state != null) {
                throw new GameCannotBeCreatedMoreThanOnce();
            }
            UUID gameId = ((CreateGame)cmd).component1-tte2sNk();
            ZonedDateTime timestamp = ((CreateGame)cmd).component2-uc7Y9rs();
            UUID creator = ((CreateGame)cmd).component3-zzfoIEA();
            int numberOfRounds = ((CreateGame)cmd).component4-esUtRFY();
            Object[] objectArray = new GameCreated[]{new GameCreated(gameId, timestamp, creator, numberOfRounds, null)};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else if (gameCommand instanceof PlayHand) {
            if (state == null) {
                throw new GameDoesNotExist();
            }
            sequence = GameLogic.INSTANCE.play((PlayHand)cmd, AccumulatedChanges.Companion.initializeFrom(state));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sequence;
    }

    private static final <A, B> Function1<B, B> partial(Function2<? super A, ? super B, ? extends B> $this$partial, A a) {
        return new Function1<B, B>($this$partial, a){
            final /* synthetic */ Function2<A, B, B> $this_partial;
            final /* synthetic */ A $a;
            {
                this.$this_partial = $receiver;
                this.$a = $a;
                super(1);
            }

            public final B invoke(B b) {
                return (B)this.$this_partial.invoke(this.$a, b);
            }
        };
    }

    public static final /* synthetic */ Function1 access$partial(Function2 $receiver, Object a) {
        return BehaviorKt.partial($receiver, a);
    }
}

