/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.example.domain.rps.model;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.occurrent.example.domain.rps.model.AccumulatedChanges;
import org.occurrent.example.domain.rps.model.BehaviorKt;
import org.occurrent.example.domain.rps.model.CannotJoinTheGameTwice;
import org.occurrent.example.domain.rps.model.CannotPlayHandBecauseGameEnded;
import org.occurrent.example.domain.rps.model.DomainState;
import org.occurrent.example.domain.rps.model.FirstPlayerJoinedGame;
import org.occurrent.example.domain.rps.model.GameAlreadyHasTwoPlayers;
import org.occurrent.example.domain.rps.model.GameEnded;
import org.occurrent.example.domain.rps.model.GameEvent;
import org.occurrent.example.domain.rps.model.GameStarted;
import org.occurrent.example.domain.rps.model.GameTied;
import org.occurrent.example.domain.rps.model.GameWon;
import org.occurrent.example.domain.rps.model.Hand;
import org.occurrent.example.domain.rps.model.HandPlayed;
import org.occurrent.example.domain.rps.model.PlayerAlreadyPlayedInRound;
import org.occurrent.example.domain.rps.model.PlayerId;
import org.occurrent.example.domain.rps.model.Round;
import org.occurrent.example.domain.rps.model.RoundEnded;
import org.occurrent.example.domain.rps.model.RoundNumber;
import org.occurrent.example.domain.rps.model.RoundStarted;
import org.occurrent.example.domain.rps.model.RoundTied;
import org.occurrent.example.domain.rps.model.RoundWon;
import org.occurrent.example.domain.rps.model.SecondPlayerJoinedGame;
import org.occurrent.example.domain.rps.model.Shape;
import org.occurrent.example.domain.rps.model.Timestamp;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0005J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0005H\u0002J%\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u0015*\u00020\u0005H\u0002J\u0019\u0010\u001b\u001a\u00020\u001c*\u00020\u001cH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006 "}, d2={"Lorg/occurrent/example/domain/rps/model/GameLogic;", "", "()V", "currentRound", "Lorg/occurrent/example/domain/rps/model/Round;", "Lorg/occurrent/example/domain/rps/model/AccumulatedChanges;", "getCurrentRound", "(Lorg/occurrent/example/domain/rps/model/AccumulatedChanges;)Lorg/occurrent/example/domain/rps/model/Round;", "determineGameStatus", "Lorg/occurrent/example/domain/rps/model/GameLogic$GameStatus;", "accumulatedChanges", "play", "cmd", "LPlayHand;", "playHandAndEvaluateGameRules", "startNewRound", "timestamp", "Lorg/occurrent/example/domain/rps/model/Timestamp;", "startNewRound-QqTgOew", "(Ljava/time/ZonedDateTime;Lorg/occurrent/example/domain/rps/model/AccumulatedChanges;)Lorg/occurrent/example/domain/rps/model/AccumulatedChanges;", "beats", "", "Lorg/occurrent/example/domain/rps/model/Hand;", "other", "Lorg/occurrent/example/domain/rps/model/Shape;", "Lorg/occurrent/example/domain/rps/model/DomainState;", "isRoundOngoing", "next", "Lorg/occurrent/example/domain/rps/model/RoundNumber;", "next-GPcnYTM", "(I)I", "GameStatus", "example-rps-model"})
final class GameLogic {
    @NotNull
    public static final GameLogic INSTANCE = new GameLogic();

    private GameLogic() {
    }

    @NotNull
    public final AccumulatedChanges play(@NotNull PlayHand cmd, @NotNull AccumulatedChanges accumulatedChanges) {
        AccumulatedChanges accumulatedChanges2;
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)accumulatedChanges, (String)"accumulatedChanges");
        PlayHand playHand = cmd;
        ZonedDateTime timestamp = playHand.component1-uc7Y9rs();
        UUID playerId = playHand.component2-3wP31F4();
        DomainState state = accumulatedChanges.getCurrentState();
        UUID gameId = state.getGameId-tte2sNk();
        DomainState domainState = state;
        if (domainState instanceof DomainState.Created) {
            accumulatedChanges2 = accumulatedChanges.plus((Function1<? super AccumulatedChanges, AccumulatedChanges>)BehaviorKt.access$partial((Function2)new Function2<Timestamp, AccumulatedChanges, AccumulatedChanges>((Object)this){

                @NotNull
                public final AccumulatedChanges invoke-QqTgOew(@NotNull ZonedDateTime p0, @NotNull AccumulatedChanges p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return GameLogic.access$startNewRound-QqTgOew((GameLogic)this.receiver, p0, p1);
                }
            }, Timestamp.box-impl(cmd.getTimestamp-uc7Y9rs()))).plus(new GameStarted(gameId, timestamp, null)).plus((Function1<? super AccumulatedChanges, AccumulatedChanges>)BehaviorKt.access$partial((Function2)new Function2<PlayHand, AccumulatedChanges, AccumulatedChanges>((Object)this){

                @NotNull
                public final AccumulatedChanges invoke(@NotNull PlayHand p0, @NotNull AccumulatedChanges p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((GameLogic)this.receiver).play(p0, p1);
                }
            }, cmd));
        } else if (domainState instanceof DomainState.Started) {
            accumulatedChanges2 = accumulatedChanges.plus(new FirstPlayerJoinedGame(gameId, timestamp, playerId, null)).plus((Function1<? super AccumulatedChanges, AccumulatedChanges>)BehaviorKt.access$partial((Function2)new Function2<PlayHand, AccumulatedChanges, AccumulatedChanges>((Object)this){

                @NotNull
                public final AccumulatedChanges invoke(@NotNull PlayHand p0, @NotNull AccumulatedChanges p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return GameLogic.access$playHandAndEvaluateGameRules((GameLogic)this.receiver, p0, p1);
                }
            }, cmd));
        } else if (domainState instanceof DomainState.FirstPlayerJoined) {
            if (PlayerId.equals-impl0(playerId, ((DomainState.FirstPlayerJoined)state).getFirstPlayer-3wP31F4())) {
                throw new CannotJoinTheGameTwice();
            }
            accumulatedChanges2 = accumulatedChanges.plus(new SecondPlayerJoinedGame(gameId, timestamp, playerId, null)).plus((Function1<? super AccumulatedChanges, AccumulatedChanges>)BehaviorKt.access$partial((Function2)new Function2<PlayHand, AccumulatedChanges, AccumulatedChanges>((Object)this){

                @NotNull
                public final AccumulatedChanges invoke(@NotNull PlayHand p0, @NotNull AccumulatedChanges p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return GameLogic.access$playHandAndEvaluateGameRules((GameLogic)this.receiver, p0, p1);
                }
            }, cmd));
        } else if (domainState instanceof DomainState.BothPlayersJoined) {
            if (!PlayerId.equals-impl0(((DomainState.BothPlayersJoined)state).getFirstPlayer-3wP31F4(), playerId) && !PlayerId.equals-impl0(((DomainState.BothPlayersJoined)state).getSecondPlayer-3wP31F4(), playerId)) {
                throw new GameAlreadyHasTwoPlayers();
            }
            accumulatedChanges2 = (this.isRoundOngoing(accumulatedChanges) ? accumulatedChanges : accumulatedChanges.plus((Function1<? super AccumulatedChanges, AccumulatedChanges>)BehaviorKt.access$partial((Function2)new Function2<Timestamp, AccumulatedChanges, AccumulatedChanges>((Object)this){

                @NotNull
                public final AccumulatedChanges invoke-QqTgOew(@NotNull ZonedDateTime p0, @NotNull AccumulatedChanges p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return GameLogic.access$startNewRound-QqTgOew((GameLogic)this.receiver, p0, p1);
                }
            }, Timestamp.box-impl(cmd.getTimestamp-uc7Y9rs())))).plus((Function1<? super AccumulatedChanges, AccumulatedChanges>)BehaviorKt.access$partial((Function2)new Function2<PlayHand, AccumulatedChanges, AccumulatedChanges>((Object)this){

                @NotNull
                public final AccumulatedChanges invoke(@NotNull PlayHand p0, @NotNull AccumulatedChanges p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return GameLogic.access$playHandAndEvaluateGameRules((GameLogic)this.receiver, p0, p1);
                }
            }, cmd));
        } else {
            if (domainState instanceof DomainState.Ended) {
                throw new CannotPlayHandBecauseGameEnded();
            }
            throw new NoWhenBranchMatchedException();
        }
        return accumulatedChanges2;
    }

    private final AccumulatedChanges startNewRound-QqTgOew(ZonedDateTime timestamp, AccumulatedChanges accumulatedChanges) {
        RoundStarted roundStarted;
        DomainState state = accumulatedChanges.getCurrentState();
        Round round = this.currentRound(state);
        RoundNumber currentRoundNumber = round == null ? null : RoundNumber.box-impl(round.getRoundNumber-W45pMc4());
        if (currentRoundNumber == null) {
            roundStarted = new RoundStarted(state.getGameId-tte2sNk(), timestamp, RoundNumber.Companion.invoke-VjY2Gv4(1), null);
        } else if (currentRoundNumber.unbox-impl() < state.getBestOfRounds-esUtRFY()) {
            roundStarted = new RoundStarted(state.getGameId-tte2sNk(), timestamp, this.next-GPcnYTM(currentRoundNumber.unbox-impl()), null);
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Cannot start round since it would exceed ", (Object)state.getBestOfRounds-esUtRFY()));
        }
        RoundStarted newEvent = roundStarted;
        return accumulatedChanges.plus(newEvent);
    }

    private final AccumulatedChanges playHandAndEvaluateGameRules(PlayHand cmd, AccumulatedChanges accumulatedChanges) {
        AccumulatedChanges accumulatedChanges2;
        DomainState state = accumulatedChanges.getCurrentState();
        PlayHand playHand = cmd;
        ZonedDateTime timestamp = playHand.component1-uc7Y9rs();
        UUID playerId = playHand.component2-3wP31F4();
        Shape shapeOfHand = playHand.component3();
        UUID gameId = state.getGameId-tte2sNk();
        Round round = this.currentRound(state);
        if (round == null) {
            throw new IllegalStateException("Cannot play when round is not started");
        }
        Round round2 = round;
        if (round2 instanceof Round.WaitingForSecondHand && PlayerId.equals-impl0(((Round.WaitingForSecondHand)round2).getFirstHand().getPlayerId-3wP31F4(), cmd.getPlayerId-3wP31F4())) {
            throw new PlayerAlreadyPlayedInRound();
        }
        int roundNumber = round2.getRoundNumber-W45pMc4();
        AccumulatedChanges changesAfterHandPlayed = accumulatedChanges.plus(new HandPlayed(gameId, timestamp, playerId, shapeOfHand, roundNumber, null));
        Round currentRound = this.getCurrentRound(accumulatedChanges);
        if (currentRound instanceof Round.WaitingForFirstHand) {
            accumulatedChanges2 = changesAfterHandPlayed;
        } else if (currentRound instanceof Round.WaitingForSecondHand) {
            List list;
            Hand firstHand = ((Round.WaitingForSecondHand)currentRound).getFirstHand();
            Hand secondHand = new Hand(playerId, shapeOfHand, null);
            GameEvent roundOutcomeEvent = firstHand.getShape() == secondHand.getShape() ? (GameEvent)new RoundTied(gameId, timestamp, roundNumber, null) : (this.beats(firstHand, secondHand) ? (GameEvent)new RoundWon(gameId, timestamp, roundNumber, firstHand.getPlayerId-3wP31F4(), null) : (GameEvent)new RoundWon(gameId, timestamp, roundNumber, secondHand.getPlayerId-3wP31F4(), null));
            Object[] objectArray = new GameEvent[]{roundOutcomeEvent, new RoundEnded(gameId, timestamp, roundNumber, null)};
            AccumulatedChanges changesAfterRoundEnded = changesAfterHandPlayed.plus(CollectionsKt.listOf((Object[])objectArray));
            GameStatus status = this.determineGameStatus(changesAfterRoundEnded);
            if (Intrinsics.areEqual((Object)status, (Object)GameStatus.NotEnded.INSTANCE)) {
                list = CollectionsKt.emptyList();
            } else if (Intrinsics.areEqual((Object)status, (Object)GameStatus.Tied.INSTANCE)) {
                Object[] objectArray2 = new GameEvent[]{new GameTied(gameId, timestamp, null), new GameEnded(gameId, timestamp, null)};
                list = CollectionsKt.listOf((Object[])objectArray2);
            } else if (status instanceof GameStatus.Won) {
                Object[] objectArray3 = new GameEvent[]{new GameWon(gameId, timestamp, ((GameStatus.Won)status).getWinner-3wP31F4(), null), new GameEnded(gameId, timestamp, null)};
                list = CollectionsKt.listOf((Object[])objectArray3);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            accumulatedChanges2 = changesAfterRoundEnded.plus(list);
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Cannot play round when round is in state ", (Object)Reflection.getOrCreateKotlinClass(currentRound.getClass()).getSimpleName()));
        }
        return accumulatedChanges2;
    }

    /*
     * WARNING - void declaration
     */
    private final GameStatus determineGameStatus(AccumulatedChanges accumulatedChanges) {
        GameStatus gameStatus;
        DomainState state = accumulatedChanges.getCurrentState();
        if (state instanceof DomainState.BothPlayersJoined) {
            int numberOfWinsForPlayer2;
            Integer $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Object value$iv$iv$iv;
            Object object;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            int maxNumberOfRounds = state.getBestOfRounds-esUtRFY();
            Round round = this.currentRound(state);
            Intrinsics.checkNotNull((Object)round);
            int roundNumber = round.getRoundNumber-W45pMc4();
            Iterable iterable = (Iterable)((DomainState.BothPlayersJoined)state).getRounds();
            boolean $i$f$groupBy = false;
            void var8_10 = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                Round round2 = (Round)element$iv$iv;
                boolean bl = false;
                object = round2 instanceof Round.Won ? (Round.Won)round2 : null;
                UUID uUID = object == null ? null : ((Round.Won)object).getWinner-3wP31F4();
                PlayerId key$iv$iv = uUID != null ? PlayerId.box-impl(uUID) : null;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$mapValues22 = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $dstr$_u24__u24$wonRounds;
                void it$iv$iv;
                object = (Map.Entry)element$iv$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                Object k = it$iv$iv.getKey();
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                Map map2 = map;
                boolean bl3 = false;
                void var21_30 = $dstr$_u24__u24$wonRounds;
                boolean bl4 = false;
                List wonRounds = (List)var21_30.getValue();
                Integer n = wonRounds.size();
                map2.put(k2, n);
            }
            Map numberOfWinsPerPlayer = destination$iv$iv;
            Integer $i$f$mapValues22 = (Integer)numberOfWinsPerPlayer.get(PlayerId.box-impl(((DomainState.BothPlayersJoined)state).getFirstPlayer-3wP31F4()));
            int numberOfWinsForPlayer1 = $i$f$mapValues22 == null ? 0 : $i$f$mapValues22;
            $this$mapValuesTo$iv$iv = (Integer)numberOfWinsPerPlayer.get(PlayerId.box-impl(((DomainState.BothPlayersJoined)state).getSecondPlayer-3wP31F4()));
            int n = numberOfWinsForPlayer2 = $this$mapValuesTo$iv$iv == null ? 0 : $this$mapValuesTo$iv$iv;
            if (maxNumberOfRounds == roundNumber) {
                gameStatus = numberOfWinsForPlayer1 > numberOfWinsForPlayer2 ? (GameStatus)new GameStatus.Won(((DomainState.BothPlayersJoined)state).getFirstPlayer-3wP31F4(), null) : (numberOfWinsForPlayer2 > numberOfWinsForPlayer1 ? (GameStatus)new GameStatus.Won(((DomainState.BothPlayersJoined)state).getSecondPlayer-3wP31F4(), null) : (GameStatus)GameStatus.Tied.INSTANCE);
            } else {
                int numberOfRoundsRequiredForMajorityWin = maxNumberOfRounds / 2 + 1;
                gameStatus = numberOfWinsForPlayer1 == numberOfRoundsRequiredForMajorityWin ? (GameStatus)new GameStatus.Won(((DomainState.BothPlayersJoined)state).getFirstPlayer-3wP31F4(), null) : (numberOfWinsForPlayer2 == numberOfRoundsRequiredForMajorityWin ? (GameStatus)new GameStatus.Won(((DomainState.BothPlayersJoined)state).getSecondPlayer-3wP31F4(), null) : (GameStatus)GameStatus.NotEnded.INSTANCE);
            }
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Cannot determine game outcome when game is in state ", (Object)Reflection.getOrCreateKotlinClass(state.getClass()).getSimpleName()));
        }
        return gameStatus;
    }

    private final Round getCurrentRound(AccumulatedChanges $this$currentRound) {
        Round round;
        DomainState state = $this$currentRound.getCurrentState();
        if (state instanceof DomainState.Started) {
            round = ((DomainState.Started)state).getRound();
        } else if (state instanceof DomainState.FirstPlayerJoined) {
            round = ((DomainState.FirstPlayerJoined)state).getRound();
        } else if (state instanceof DomainState.BothPlayersJoined) {
            round = (Round)CollectionsKt.last((List)((List)((DomainState.BothPlayersJoined)state).getRounds()));
        } else {
            throw new IllegalStateException("No round is started");
        }
        return round;
    }

    private final boolean isRoundOngoing(AccumulatedChanges $this$isRoundOngoing) {
        boolean bl;
        Round round = this.getCurrentRound($this$isRoundOngoing);
        if (round instanceof Round.Tied) {
            bl = false;
        } else if (round instanceof Round.Won) {
            bl = false;
        } else if (round instanceof Round.WaitingForFirstHand) {
            bl = true;
        } else if (round instanceof Round.WaitingForSecondHand) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private final Round currentRound(DomainState $this$currentRound) {
        Round round;
        DomainState domainState = $this$currentRound;
        if (domainState instanceof DomainState.Created) {
            round = null;
        } else if (domainState instanceof DomainState.Started) {
            round = ((DomainState.Started)$this$currentRound).getRound();
        } else if (domainState instanceof DomainState.FirstPlayerJoined) {
            round = ((DomainState.FirstPlayerJoined)$this$currentRound).getRound();
        } else if (domainState instanceof DomainState.BothPlayersJoined) {
            round = (Round)CollectionsKt.last((List)((List)((DomainState.BothPlayersJoined)$this$currentRound).getRounds()));
        } else {
            if (domainState instanceof DomainState.Ended) {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Cannot get round number when game is in state ", (Object)Reflection.getOrCreateKotlinClass($this$currentRound.getClass()).getSimpleName()));
            }
            throw new NoWhenBranchMatchedException();
        }
        return round;
    }

    private final int next-GPcnYTM(int $this$next_u2dGPcnYTM) {
        return RoundNumber.Companion.invoke-VjY2Gv4($this$next_u2dGPcnYTM + 1);
    }

    private final boolean beats(Hand $this$beats, Hand other) {
        return this.beats($this$beats.getShape(), other.getShape());
    }

    private final boolean beats(Shape $this$beats, Shape other) {
        Pair pair = TuplesKt.to((Object)((Object)$this$beats), (Object)((Object)other));
        return Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)Shape.ROCK, (Object)Shape.SCISSORS)) ? true : (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)Shape.PAPER, (Object)Shape.ROCK)) ? true : Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)Shape.SCISSORS, (Object)Shape.PAPER)));
    }

    public static final /* synthetic */ AccumulatedChanges access$startNewRound-QqTgOew(GameLogic $this, ZonedDateTime timestamp, AccumulatedChanges accumulatedChanges) {
        return $this.startNewRound-QqTgOew(timestamp, accumulatedChanges);
    }

    public static final /* synthetic */ AccumulatedChanges access$playHandAndEvaluateGameRules(GameLogic $this, PlayHand cmd, AccumulatedChanges accumulatedChanges) {
        return $this.playHandAndEvaluateGameRules(cmd, accumulatedChanges);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00a8\u0006\b"}, d2={"Lorg/occurrent/example/domain/rps/model/GameLogic$GameStatus;", "", "NotEnded", "Tied", "Won", "Lorg/occurrent/example/domain/rps/model/GameLogic$GameStatus$Won;", "Lorg/occurrent/example/domain/rps/model/GameLogic$GameStatus$Tied;", "Lorg/occurrent/example/domain/rps/model/GameLogic$GameStatus$NotEnded;", "example-rps-model"})
    private static interface GameStatus {

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\b\u001a\u00020\u0003H\u00c6\u0003\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\t\u0010\u0006J \u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001c\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0015"}, d2={"Lorg/occurrent/example/domain/rps/model/GameLogic$GameStatus$Won;", "Lorg/occurrent/example/domain/rps/model/GameLogic$GameStatus;", "winner", "Lorg/occurrent/example/domain/rps/model/PlayerId;", "(Ljava/util/UUID;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getWinner-3wP31F4", "()Ljava/util/UUID;", "Ljava/util/UUID;", "component1", "component1-3wP31F4", "copy", "copy-JZhD1VI", "(Ljava/util/UUID;)Lorg/occurrent/example/domain/rps/model/GameLogic$GameStatus$Won;", "equals", "", "other", "", "hashCode", "", "toString", "", "example-rps-model"})
        public static final class Won
        implements GameStatus {
            @NotNull
            private final UUID winner;

            private Won(UUID winner) {
                this.winner = winner;
            }

            @NotNull
            public final UUID getWinner-3wP31F4() {
                return this.winner;
            }

            @NotNull
            public final UUID component1-3wP31F4() {
                return this.winner;
            }

            @NotNull
            public final Won copy-JZhD1VI(@NotNull UUID winner) {
                Intrinsics.checkNotNullParameter((Object)winner, (String)"winner");
                return new Won(winner, null);
            }

            public static /* synthetic */ Won copy-JZhD1VI$default(Won won, UUID uUID, int n, Object object) {
                if ((n & 1) != 0) {
                    uUID = won.winner;
                }
                return won.copy-JZhD1VI(uUID);
            }

            @NotNull
            public String toString() {
                return "Won(winner=" + PlayerId.toString-impl(this.winner) + ')';
            }

            public int hashCode() {
                return PlayerId.hashCode-impl(this.winner);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Won)) {
                    return false;
                }
                Won won = (Won)other;
                return PlayerId.equals-impl0(this.winner, won.winner);
            }

            public /* synthetic */ Won(UUID winner, DefaultConstructorMarker $constructor_marker) {
                this(winner);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/occurrent/example/domain/rps/model/GameLogic$GameStatus$Tied;", "Lorg/occurrent/example/domain/rps/model/GameLogic$GameStatus;", "()V", "example-rps-model"})
        public static final class Tied
        implements GameStatus {
            @NotNull
            public static final Tied INSTANCE = new Tied();

            private Tied() {
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/occurrent/example/domain/rps/model/GameLogic$GameStatus$NotEnded;", "Lorg/occurrent/example/domain/rps/model/GameLogic$GameStatus;", "()V", "example-rps-model"})
        public static final class NotEnded
        implements GameStatus {
            @NotNull
            public static final NotEnded INSTANCE = new NotEnded();

            private NotEnded() {
            }
        }
    }
}

