/*
 * Decompiled with CFR 0.152.
 */
package org.objectledge.ckpackager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackScriptParser {
    private static final int BUFFER_SIZE = 16384;
    private static final String PACK_FILE_ENCODING = "UTF-8";
    private final Scriptable globalScope;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackScriptParser() {
        Context cx = Context.enter();
        try {
            this.globalScope = cx.initStandardObjects();
        }
        finally {
            Context.exit();
        }
    }

    private static String readScript(File scriptFile) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        Reader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(scriptFile), PACK_FILE_ENCODING);
            StringWriter writer = new StringWriter();
            int i = 0;
            char[] buff = new char[16384];
            while (i >= 0) {
                i = reader.read(buff);
                if (i <= 0) continue;
                writer.write(buff, 0, i);
            }
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            IOException ee = new IOException("failed to read script + " + scriptFile.getAbsolutePath());
            ee.initCause(e);
            throw ee;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public void parseScript(File scriptFile, File outputDirectory, List<File> sourceFiles, List<File> outputFiles) throws IOException {
        File scriptDir = scriptFile.getParentFile();
        Context cx = Context.enter();
        try {
            Scriptable scope2 = cx.newObject(this.globalScope);
            String scriptBody = PackScriptParser.readScript(scriptFile);
            cx.evaluateString(scope2, "var script = {" + scriptBody + "\n};", scriptFile.getAbsolutePath(), 1, null);
            Scriptable script = (Scriptable)scope2.get("script", scope2);
            Scriptable packages = (Scriptable)script.get("packages", script);
            int i = 0;
            while (packages.has(i, packages)) {
                Scriptable packageDef = (Scriptable)packages.get(i++, packages);
                String output = (String)packageDef.get("output", packageDef);
                outputFiles.add(new File(outputDirectory, output));
                Scriptable files = (Scriptable)packageDef.get("files", packageDef);
                int j = 0;
                while (files.has(j, files)) {
                    String file = (String)files.get(j++, files);
                    sourceFiles.add(new File(scriptDir, file));
                }
            }
        }
        catch (Exception e) {
            IOException ee = new IOException("failed to parse script + " + scriptFile.getAbsolutePath());
            ee.initCause(e);
            throw ee;
        }
        finally {
            Context.exit();
        }
    }
}

