/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.utils.geometry;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPoint;

public class CurvedProfileGenerator {
    public static double toCurve(double mn, double d) {
        return 2.0 * Math.max(1000.0, 8.0 * d) * Math.asin(mn / (2.0 * Math.max(1000.0, 8.0 * d)));
    }

    public static List<CutPoint> applyTransformation(List<CutPoint> flatProfile, boolean inversed) {
        CutPoint sourcePoint = flatProfile.get(0);
        CutPoint receiverPoint = flatProfile.get(flatProfile.size() - 1);
        Coordinate cs = sourcePoint.getCoordinate();
        Coordinate cr = receiverPoint.getCoordinate();
        ArrayList<CutPoint> curvedProfile = new ArrayList<CutPoint>();
        Coordinate[] curvedCoords = CurvedProfileGenerator.applyTransformation(cs, cr, (Coordinate[])flatProfile.stream().map(CutPoint::getCoordinate).toArray(Coordinate[]::new), inversed);
        Coordinate[] groundCoords = CurvedProfileGenerator.applyTransformation(cs, cr, (Coordinate[])flatProfile.stream().map(p -> new Coordinate(p.getCoordinate().x, p.getCoordinate().y, p.zGround)).toArray(Coordinate[]::new), inversed);
        for (int i = 0; i < curvedCoords.length; ++i) {
            CutPoint cp = flatProfile.get(i);
            CutPoint newCp = cp.clone();
            newCp.setZGround(groundCoords[i].z);
            newCp.setCoordinate(curvedCoords[i]);
            curvedProfile.add(newCp);
        }
        return curvedProfile;
    }

    public static Coordinate[] applyTransformation(Coordinate cs, Coordinate cr, Coordinate[] flatProfile, boolean inverse) {
        Coordinate[] curvedProfile = new Coordinate[flatProfile.length];
        double d = cs.distance3D(cr);
        double radius = Math.max(1000.0, 8.0 * d);
        double base = Math.sqrt(radius * radius - d * d / 4.0);
        for (int i = 0; i < flatProfile.length; ++i) {
            Coordinate p = flatProfile[i];
            double z = base - Math.sqrt(radius * radius - Math.pow(p.distance3D(cs) - d / 2.0, 2.0));
            if (inverse) {
                z = -z;
            }
            curvedProfile[i] = new Coordinate(p.x, p.y, p.z + z);
        }
        return curvedProfile;
    }
}

