/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.profilebuilder;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.noise_planet.noisemodelling.pathfinder.path.Scene;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.ProfileBuilder;

public class ProfileBuilderDecorator {
    private static final GeometryFactory FACTORY = new GeometryFactory();
    private final Scene data;

    public ProfileBuilderDecorator(ProfileBuilder profileBuilder) {
        this.data = new Scene(profileBuilder);
    }

    public ProfileBuilderDecorator addSource(double x, double y, double z) {
        this.data.addSource((Geometry)FACTORY.createPoint(new Coordinate(x, y, z)));
        return this;
    }

    public ProfileBuilderDecorator addSource(Geometry geom) {
        this.data.addSource(geom);
        return this;
    }

    public ProfileBuilderDecorator addReceiver(double x, double y, double z) {
        this.data.addReceiver(new Coordinate(x, y, z));
        return this;
    }

    public ProfileBuilderDecorator vEdgeDiff(boolean hDiff) {
        this.data.setComputeHorizontalDiffraction(hDiff);
        return this;
    }

    public ProfileBuilderDecorator hEdgeDiff(boolean vDiff) {
        this.data.setComputeVerticalDiffraction(vDiff);
        return this;
    }

    public ProfileBuilderDecorator setGs(double gs) {
        this.data.setDefaultGroundAttenuation(gs);
        return this;
    }

    public ProfileBuilderDecorator setMaximumPropagationDistance(double maximumPropagationDistance) {
        this.data.maxSrcDist = maximumPropagationDistance;
        return this;
    }

    public Scene build() {
        return this.data;
    }
}

