/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.profilebuilder;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPoint;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointDistanceComparator;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointGroundEffect;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointReceiver;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointReflection;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointSource;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointTopography;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointWall;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.CurvedProfileGenerator;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.JTSUtility;

public class CutProfile {
    public ArrayList<CutPoint> cutPoints = new ArrayList();
    @JsonIgnore
    public boolean hasBuildingIntersection = false;
    @JsonIgnore
    public boolean hasTopographyIntersection = false;
    public boolean curvedPath = false;
    public PROFILE_TYPE profileType = PROFILE_TYPE.DIRECT;

    public CutProfile() {
    }

    public CutProfile(CutPointSource source, CutPointReceiver receiver) {
        this.cutPoints.add(source);
        this.cutPoints.add(receiver);
    }

    public PROFILE_TYPE getProfileType() {
        return this.profileType;
    }

    public void setProfileType(PROFILE_TYPE profileType) {
        this.profileType = profileType;
    }

    public void setCurvedPath(boolean curvedPath) {
        this.curvedPath = curvedPath;
    }

    public boolean isCurvedPath() {
        return this.curvedPath;
    }

    public ArrayList<CutPoint> getCutPoints() {
        return this.cutPoints;
    }

    public void insertCutPoint(boolean sortBySourcePosition, CutPoint ... cutPointsToInsert) {
        CutPointSource sourcePoint = this.getSource();
        CutPointReceiver receiverPoint = this.getReceiver();
        this.cutPoints.addAll(1, Arrays.asList(cutPointsToInsert));
        if (sortBySourcePosition) {
            int receiverIndex;
            this.sort(sourcePoint.coordinate);
            int sourceIndex = this.cutPoints.indexOf(sourcePoint);
            if (sourceIndex != 0) {
                this.cutPoints.remove(sourceIndex);
                this.cutPoints.add(0, sourcePoint);
            }
            if ((receiverIndex = this.cutPoints.indexOf(receiverPoint)) != this.cutPoints.size() - 1) {
                this.cutPoints.remove(receiverIndex);
                this.cutPoints.add(this.cutPoints.size(), receiverPoint);
            }
        }
    }

    public void sort(Coordinate c0) {
        this.cutPoints.sort(new CutPointDistanceComparator(c0));
    }

    @JsonIgnore
    public double getGPath(CutPoint p0, CutPoint p1, double buildingRoofG) {
        double totalLength = 0.0;
        double rsLength = 0.0;
        int i0 = this.cutPoints.indexOf(p0);
        int i1 = this.cutPoints.indexOf(p1);
        if (i0 == -1 || i1 == -1 || i1 < i0) {
            return 0.0;
        }
        boolean aboveRoof = false;
        for (int index = 0; index < i1; ++index) {
            CutPoint current = this.cutPoints.get(index);
            if (current instanceof CutPointWall) {
                CutPointWall currentWall = (CutPointWall)current;
                if (!aboveRoof && currentWall.intersectionType.equals((Object)CutPointWall.INTERSECTION_TYPE.BUILDING_ENTER)) {
                    aboveRoof = true;
                } else if (aboveRoof && currentWall.intersectionType.equals((Object)CutPointWall.INTERSECTION_TYPE.BUILDING_EXIT)) {
                    aboveRoof = false;
                }
            }
            if (index < i0) continue;
            double segmentLength = current.getCoordinate().distance(this.cutPoints.get(index + 1).getCoordinate());
            rsLength += segmentLength * (aboveRoof ? buildingRoofG : current.getGroundCoefficient());
            totalLength += segmentLength;
        }
        return rsLength / totalLength;
    }

    @JsonIgnore
    public double getGPath() {
        if (!this.cutPoints.isEmpty()) {
            return this.getGPath(this.cutPoints.get(0), this.cutPoints.get(this.cutPoints.size() - 1), 0.0);
        }
        return 0.0;
    }

    @JsonIgnore
    public boolean isFreeField() {
        return !this.hasBuildingIntersection && !this.hasTopographyIntersection;
    }

    public String toString() {
        return "CutProfile{pts=" + String.valueOf(this.cutPoints) + ", hasBuildingIntersection=" + this.hasBuildingIntersection + ", hasTopographyIntersection=" + this.hasTopographyIntersection + "}";
    }

    public List<Coordinate> computePts2DGround() {
        return this.computePts2DGround(0.0, null);
    }

    public List<Coordinate> computePts2D(boolean curvedPath) {
        List<Object> pts2D = curvedPath ? CurvedProfileGenerator.applyTransformation(this.cutPoints, false).stream().map(CutPoint::getCoordinate).collect(Collectors.toList()) : this.cutPoints.stream().map(CutPoint::getCoordinate).collect(Collectors.toList());
        pts2D = JTSUtility.getNewCoordinateSystem(pts2D);
        return pts2D;
    }

    public List<Coordinate> computePts2D() {
        return this.computePts2D(false);
    }

    public List<Integer> getConvexHullIndices(List<Coordinate> coordinates2d) {
        if (coordinates2d.size() != this.cutPoints.size()) {
            throw new IllegalArgumentException("Coordinates size must be equal to cut points size");
        }
        ArrayList<Coordinate> convexHullInput = new ArrayList<Coordinate>();
        convexHullInput.add(coordinates2d.get(0));
        for (int idPoint = 1; idPoint < this.cutPoints.size() - 1; ++idPoint) {
            CutPoint currentPoint = this.cutPoints.get(idPoint);
            if (!(currentPoint instanceof CutPointTopography) && (!(currentPoint instanceof CutPointWall) || Double.compare(currentPoint.getCoordinate().z, currentPoint.getzGround()) == 0)) continue;
            convexHullInput.add(coordinates2d.get(idPoint));
        }
        convexHullInput.add(coordinates2d.get(coordinates2d.size() - 1));
        List<Object> convexHullPoints = new ArrayList();
        if (convexHullInput.size() > 2) {
            GeometryFactory geomFactory = new GeometryFactory();
            Coordinate[] coordsArray = convexHullInput.toArray(new Coordinate[0]);
            ConvexHull convexHull = new ConvexHull(coordsArray, geomFactory);
            Coordinate[] convexHullCoords = convexHull.getConvexHull().getCoordinates();
            int indexFirst = Arrays.asList(convexHull.getConvexHull().getCoordinates()).indexOf(coordinates2d.get(0));
            int indexLast = Arrays.asList(convexHull.getConvexHull().getCoordinates()).lastIndexOf(coordinates2d.get(coordinates2d.size() - 1));
            if (indexFirst == -1 || indexLast == -1 || indexFirst > indexLast) {
                throw new IllegalArgumentException("Wrong input data ");
            }
            convexHullCoords = Arrays.copyOfRange(convexHullCoords, indexFirst, indexLast + 1);
            CoordinateSequence coordinatesSequence = geomFactory.getCoordinateSequenceFactory().create(convexHullCoords);
            LineString geom = geomFactory.createLineString(coordinatesSequence);
            Geometry uniqueGeom = geom.union();
            convexHullCoords = uniqueGeom.getCoordinates();
            if (convexHullCoords.length == 3) {
                convexHullPoints = Arrays.asList(convexHullCoords);
            } else {
                for (Coordinate convexHullCoordinates : convexHullCoords) {
                    if (convexHullCoordinates.y == Double.MAX_VALUE || Double.isInfinite(convexHullCoordinates.y)) continue;
                    convexHullPoints.add(convexHullCoordinates);
                }
            }
        } else {
            convexHullPoints = convexHullInput;
        }
        return convexHullPoints.stream().map(coordinates2d::indexOf).collect(Collectors.toList());
    }

    public List<Coordinate> computePts2DGround(List<Integer> index) {
        return this.computePts2DGround(0.0, index);
    }

    public static List<Coordinate> computePtsGround(List<CutPoint> pts, List<Integer> index) {
        CutPointWall cutPointWall;
        ArrayList<Coordinate> pts2D = new ArrayList<Coordinate>(pts.size());
        if (pts.isEmpty()) {
            return pts2D;
        }
        boolean overArea = false;
        for (CutPoint cut : pts) {
            if (!(cut instanceof CutPointWall)) continue;
            cutPointWall = (CutPointWall)cut;
            if (!cutPointWall.intersectionType.equals((Object)CutPointWall.INTERSECTION_TYPE.BUILDING_EXIT)) break;
            overArea = true;
        }
        for (CutPoint cut : pts) {
            if (cut instanceof CutPointGroundEffect) {
                if (index == null) continue;
                index.add(pts2D.size() - 1);
                continue;
            }
            if (cut instanceof CutPointWall) {
                cutPointWall = (CutPointWall)cut;
                if (cutPointWall.intersectionType.equals((Object)CutPointWall.INTERSECTION_TYPE.BUILDING_ENTER) || cutPointWall.intersectionType.equals((Object)CutPointWall.INTERSECTION_TYPE.THIN_WALL_ENTER_EXIT)) {
                    pts2D.add(new Coordinate(cut.getCoordinate().x, cut.getCoordinate().y, cut.getzGround().doubleValue()));
                    overArea = true;
                }
                pts2D.add(new Coordinate(cut.getCoordinate().x, cut.getCoordinate().y, cut.getCoordinate().z));
                if (cutPointWall.intersectionType.equals((Object)CutPointWall.INTERSECTION_TYPE.BUILDING_EXIT) || cutPointWall.intersectionType.equals((Object)CutPointWall.INTERSECTION_TYPE.THIN_WALL_ENTER_EXIT)) {
                    pts2D.add(new Coordinate(cut.getCoordinate().x, cut.getCoordinate().y, cut.getzGround().doubleValue()));
                    overArea = false;
                }
            } else if (cut instanceof CutPointReflection) {
                pts2D.add(new Coordinate(cut.getCoordinate().x, cut.getCoordinate().y, cut.getzGround().doubleValue()));
                pts2D.add(new Coordinate(cut.getCoordinate().x, cut.getCoordinate().y, cut.getzGround().doubleValue()));
                pts2D.add(new Coordinate(cut.getCoordinate().x, cut.getCoordinate().y, cut.getzGround().doubleValue()));
            } else if (!overArea || !(cut instanceof CutPointTopography)) {
                pts2D.add(new Coordinate(cut.getCoordinate().x, cut.getCoordinate().y, cut.getzGround().doubleValue()));
            }
            if (index == null) continue;
            index.add(pts2D.size() - 1);
        }
        return pts2D;
    }

    public static List<Coordinate> computePts2DGround(List<CutPoint> pts, double tolerance, List<Integer> index) {
        return JTSUtility.getNewCoordinateSystem(CutProfile.computePtsGround(pts, index), tolerance);
    }

    public List<Coordinate> computePts2DGround(double tolerance, List<Integer> index) {
        return CutProfile.computePts2DGround(this.cutPoints, tolerance, index);
    }

    @JsonIgnore
    public CutPointSource getSource() {
        return !this.cutPoints.isEmpty() && this.cutPoints.get(0) instanceof CutPointSource ? (CutPointSource)this.cutPoints.get(0) : null;
    }

    @JsonIgnore
    public CutPointReceiver getReceiver() {
        return !this.cutPoints.isEmpty() && this.cutPoints.get(this.cutPoints.size() - 1) instanceof CutPointReceiver ? (CutPointReceiver)this.cutPoints.get(this.cutPoints.size() - 1) : null;
    }

    public static enum PROFILE_TYPE {
        DIRECT,
        LEFT,
        RIGHT,
        REFLECTION;

    }
}

