/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.profilebuilder;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.locationtech.jts.geom.Coordinate;
import org.noise_planet.noisemodelling.pathfinder.PathFinder;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPoint;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.Orientation;

public class CutPointSource
extends CutPoint {
    public long sourcePk = -1L;
    public double li = 1.0;
    public Orientation orientation = new Orientation();
    @JsonIgnore
    public int id = -1;

    public CutPointSource() {
    }

    public CutPointSource(Coordinate location) {
        super(location);
    }

    public CutPointSource(Coordinate coordinate, double li) {
        super(coordinate);
        this.li = li;
    }

    public CutPointSource(PathFinder.SourcePointInfo sourcePointInfo) {
        super(sourcePointInfo.position, sourcePointInfo.position.z - 0.05, 0.0);
        this.sourcePk = sourcePointInfo.getSourcePk();
        this.li = sourcePointInfo.li;
        this.orientation = sourcePointInfo.orientation;
        this.id = sourcePointInfo.sourceIndex;
    }

    public CutPointSource(CutPoint src) {
        super(src);
    }

    @Override
    public String toString() {
        return "CutPointSource{\nsourcePk=" + this.sourcePk + "\n, li=" + this.li + "\n, orientation=" + String.valueOf(this.orientation) + "\n, id=" + this.id + "\n, coordinate=" + String.valueOf(this.coordinate) + "\n, zGround=" + this.zGround + "\n, groundCoefficient=" + this.groundCoefficient + "\n}\n";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CutPointSource that = (CutPointSource)o;
        return this.sourcePk == that.sourcePk && this.id == that.id;
    }

    public int hashCode() {
        int result = Long.hashCode(this.sourcePk);
        result = 31 * result + this.id;
        return result;
    }
}

