/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.h2gis.utilities.SpatialResultSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.ProfileBuilder;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.Orientation;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.QueryGeometryStructure;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.QueryRTree;

public class Scene {
    public static final double DEFAULT_MAX_PROPAGATION_DISTANCE = 1200.0;
    public static final double DEFAULT_MAXIMUM_REF_DIST = 700.0;
    public static final double DEFAULT_RECEIVER_DIST = 1.0;
    public static final double DEFAULT_G = 0.0;
    public static final double DEFAULT_G_BUILDING = 0.0;
    public static final String YAW_DATABASE_FIELD = "YAW";
    public static final String PITCH_DATABASE_FIELD = "PITCH";
    public static final String ROLL_DATABASE_FIELD = "ROLL";
    public static final String DIRECTIVITY_DATABASE_FIELD = "DIR_ID";
    public static final String GS_DATABASE_FIELD = "GS";
    public List<Long> receiversPk = new ArrayList<Long>();
    public List<Long> sourcesPk = new ArrayList<Long>();
    public List<Coordinate> receivers = new ArrayList<Coordinate>();
    public ProfileBuilder profileBuilder;
    public QueryGeometryStructure sourcesIndex = new QueryRTree();
    public List<Geometry> sourceGeometries = new ArrayList<Geometry>();
    public Map<Long, Orientation> sourceOrientation = new HashMap<Long, Orientation>();
    public int reflexionOrder = 1;
    public double defaultGroundAttenuation = 0.0;
    boolean bodyBarrier = false;
    public boolean computeHorizontalDiffraction = true;
    public boolean computeVerticalDiffraction;
    public double maxSrcDist = 1200.0;
    public double maxRefDist = 700.0;

    public Scene() {
        this.profileBuilder = new ProfileBuilder();
    }

    public Scene(ProfileBuilder profileBuilder) {
        this.profileBuilder = profileBuilder;
    }

    public boolean isBodyBarrier() {
        return this.bodyBarrier;
    }

    public void setBodyBarrier(boolean bodyBarrier) {
        this.bodyBarrier = bodyBarrier;
    }

    public void addSource(Geometry geom) {
        this.sourceGeometries.add(geom);
        this.sourcesIndex.appendGeometry(geom, this.sourceGeometries.size() - 1);
    }

    public void addSource(Long pk, Geometry geom) {
        this.addSource(geom);
        this.sourcesPk.add(pk);
    }

    public void addSource(Long pk, Geometry geom, Orientation orientation) {
        this.addSource(pk, geom);
        this.sourceOrientation.put(pk, orientation);
    }

    public void setSources(List<Geometry> sourceGeometries) {
        this.sourcesIndex = new QueryRTree();
        int i = 0;
        for (Geometry source : sourceGeometries) {
            this.sourcesIndex.appendGeometry(source, i++);
        }
        this.sourceGeometries = sourceGeometries;
    }

    public void addReceiver(Coordinate ... receiver) {
        this.receivers.addAll(Arrays.asList(receiver));
    }

    public void addReceiver(long pk, Coordinate position) {
        this.receivers.add(position);
        this.receiversPk.add(pk);
    }

    public void addReceiver(long pk, Coordinate position, SpatialResultSet rs) {
        this.addReceiver(pk, position);
    }

    public int getReflexionOrder() {
        return this.reflexionOrder;
    }

    public void setReflexionOrder(int reflexionOrder) {
        this.reflexionOrder = reflexionOrder;
    }

    public void setComputeHorizontalDiffraction(boolean computeHorizontalDiffraction) {
        this.computeHorizontalDiffraction = computeHorizontalDiffraction;
    }

    public void setComputeVerticalDiffraction(boolean computeVerticalDiffraction) {
        this.computeVerticalDiffraction = computeVerticalDiffraction;
    }

    public void setDefaultGroundAttenuation(double gS) {
        this.defaultGroundAttenuation = gS;
    }

    public void clearSources() {
        this.sourceGeometries.clear();
        this.sourceOrientation.clear();
        this.sourcesPk.clear();
        this.sourcesIndex = new QueryRTree();
    }
}

