/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.delaunay;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.io.WKTWriter;
import org.noise_planet.noisemodelling.pathfinder.delaunay.LayerDelaunay;
import org.noise_planet.noisemodelling.pathfinder.delaunay.LayerDelaunayError;
import org.noise_planet.noisemodelling.pathfinder.delaunay.Triangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.LinearConstraint;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.SimpleTriangle;
import org.tinfour.common.Vertex;
import org.tinfour.standard.IncrementalTin;
import org.tinfour.utils.TriangleCollector;

public class LayerTinfour
implements LayerDelaunay {
    private double epsilon = 0.001;
    private static final Logger LOGGER = LoggerFactory.getLogger(LayerTinfour.class);
    public String dumpFolder = "";
    List<IConstraint> constraints = new ArrayList<IConstraint>();
    List<Integer> constraintIndex = new ArrayList<Integer>();
    Quadtree ptsIndex = new Quadtree();
    private boolean computeNeighbors = false;
    private double maxArea = 0.0;
    private List<Coordinate> vertices = new ArrayList<Coordinate>();
    private List<Triangle> triangles = new ArrayList<Triangle>();
    private List<Triangle> neighbors = new ArrayList<Triangle>();

    private Vertex addCoordinate(Coordinate coordinate, int index) {
        Envelope env = new Envelope(coordinate);
        env.expandBy(this.epsilon);
        List result = this.ptsIndex.query(env);
        Vertex found = null;
        for (Object vertex : result) {
            if (!(vertex instanceof Vertex) || !(((Vertex)vertex).getDistance(coordinate.x, coordinate.y) < this.epsilon)) continue;
            found = (Vertex)vertex;
            break;
        }
        if (found == null) {
            found = new Vertex(coordinate.x, coordinate.y, Double.isNaN(coordinate.z) ? 0.0 : coordinate.z, index);
            this.ptsIndex.insert(new Envelope(coordinate), (Object)found);
        }
        return found;
    }

    private List<SimpleTriangle> computeTriangles(IncrementalTin incrementalTin) {
        ArrayList<SimpleTriangle> triangles = new ArrayList<SimpleTriangle>(incrementalTin.countTriangles().getCount());
        Triangle.TriangleBuilder triangleBuilder = new Triangle.TriangleBuilder(triangles);
        TriangleCollector.visitSimpleTriangles((IIncrementalTin)incrementalTin, (Consumer)triangleBuilder);
        return triangles;
    }

    public String getDumpFolder() {
        return this.dumpFolder;
    }

    public void setDumpFolder(String dumpFolder) {
        this.dumpFolder = dumpFolder;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    private static Coordinate getCentroid(SimpleTriangle triangle) {
        Vertex va = triangle.getVertexA();
        Vertex vb = triangle.getVertexB();
        Vertex vc = triangle.getVertexC();
        double cx = (va.getX() + vb.getX() + vc.getX()) / 3.0;
        double cy = (va.getY() + vb.getY() + vc.getY()) / 3.0;
        double cz = (va.getZ() + vb.getZ() + vc.getZ()) / 3.0;
        return new Coordinate(cx, cy, cz);
    }

    public void dumpData() {
        GeometryFactory factory = new GeometryFactory();
        WKTWriter wktWriter = new WKTWriter(3);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.dumpFolder, "tinfour_dump.csv")));){
            for (Object vObj : this.ptsIndex.queryAll()) {
                if (!(vObj instanceof Vertex)) continue;
                Vertex v = (Vertex)vObj;
                Point p = factory.createPoint(LayerTinfour.toCoordinate(v));
                writer.write(wktWriter.write((Geometry)p));
                writer.write("\n");
            }
            for (IConstraint constraint : this.constraints) {
                LineString l;
                Vertex v;
                Coordinate[] coordinates;
                List vertices;
                if (constraint instanceof LinearConstraint) {
                    vertices = constraint.getVertices();
                    coordinates = new Coordinate[vertices.size()];
                    for (int i = 0; i < vertices.size(); ++i) {
                        v = (Vertex)vertices.get(i);
                        coordinates[i] = new Coordinate(v.getX(), v.getY(), v.getZ());
                    }
                    l = factory.createLineString(coordinates);
                    writer.write(wktWriter.write((Geometry)l));
                    writer.write("\n");
                    continue;
                }
                if (!(constraint instanceof PolygonConstraint)) continue;
                vertices = constraint.getVertices();
                if (vertices != null && vertices.size() >= 3) {
                    coordinates = new Coordinate[vertices.size() + 1];
                    for (int i = 0; i < vertices.size(); ++i) {
                        v = (Vertex)vertices.get(i);
                        coordinates[i] = new Coordinate(v.getX(), v.getY(), v.getZ());
                    }
                    coordinates[coordinates.length - 1] = coordinates[0];
                    l = factory.createPolygon(coordinates);
                    writer.write(wktWriter.write((Geometry)l));
                    writer.write("\n");
                    continue;
                }
                LOGGER.info("Weird null polygon " + String.valueOf(constraint));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void processDelaunay() throws LayerDelaunayError {
        IncrementalTin tin;
        boolean refine;
        this.triangles.clear();
        this.vertices.clear();
        List meshPoints = this.ptsIndex.queryAll();
        List<Object> simpleTriangles = new ArrayList();
        do {
            tin = new IncrementalTin();
            tin.add(meshPoints, null);
            try {
                tin.addConstraints(this.constraints, false);
            }
            catch (IllegalStateException ex) {
                if (!this.dumpFolder.isEmpty()) {
                    this.dumpData();
                }
                throw new LayerDelaunayError(ex);
            }
            refine = false;
            simpleTriangles = this.computeTriangles(tin);
            if (!(this.maxArea > 0.0)) continue;
            for (SimpleTriangle simpleTriangle : simpleTriangles) {
                if (!(simpleTriangle.getArea() > this.maxArea)) continue;
                Coordinate centroid = LayerTinfour.getCentroid(simpleTriangle);
                meshPoints.add(new Vertex(centroid.x, centroid.y, centroid.z));
                refine = true;
            }
        } while (refine);
        List verts = tin.getVertices();
        this.vertices = new ArrayList<Coordinate>(verts.size());
        HashMap<Vertex, Integer> hashMap = new HashMap<Vertex, Integer>();
        for (Vertex v : verts) {
            hashMap.put(v, this.vertices.size());
            this.vertices.add(LayerTinfour.toCoordinate(v));
        }
        HashMap<Integer, Integer> edgeIndexToTriangleIndex = new HashMap<Integer, Integer>();
        for (SimpleTriangle simpleTriangle : simpleTriangles) {
            int triangleAttribute = 0;
            if (simpleTriangle.getContainingRegion() != null && simpleTriangle.getContainingRegion().getConstraintIndex() < this.constraintIndex.size()) {
                triangleAttribute = this.constraintIndex.get(simpleTriangle.getContainingRegion().getConstraintIndex());
            }
            this.triangles.add(new Triangle((Integer)hashMap.get(simpleTriangle.getVertexA()), (Integer)hashMap.get(simpleTriangle.getVertexB()), (Integer)hashMap.get(simpleTriangle.getVertexC()), triangleAttribute));
            edgeIndexToTriangleIndex.put(simpleTriangle.getEdgeA().getIndex(), this.triangles.size() - 1);
            edgeIndexToTriangleIndex.put(simpleTriangle.getEdgeB().getIndex(), this.triangles.size() - 1);
            edgeIndexToTriangleIndex.put(simpleTriangle.getEdgeC().getIndex(), this.triangles.size() - 1);
        }
        if (this.computeNeighbors) {
            for (SimpleTriangle simpleTriangle : simpleTriangles) {
                Integer neighA = (Integer)edgeIndexToTriangleIndex.get(simpleTriangle.getEdgeA().getDual().getIndex());
                Integer neighB = (Integer)edgeIndexToTriangleIndex.get(simpleTriangle.getEdgeB().getDual().getIndex());
                Integer neighC = (Integer)edgeIndexToTriangleIndex.get(simpleTriangle.getEdgeC().getDual().getIndex());
                this.neighbors.add(new Triangle(neighA != null ? neighA : -1, neighB != null ? neighB : -1, neighC != null ? neighC : -1));
            }
        }
    }

    @Override
    public void addPolygon(Polygon newPoly, int buildingId) throws LayerDelaunayError {
        Coordinate[] coordinates = newPoly.getExteriorRing().getCoordinates();
        if (!Orientation.isCCW((Coordinate[])coordinates)) {
            CoordinateArrays.reverse((Coordinate[])coordinates);
        }
        if (coordinates.length >= 4) {
            ArrayList<Vertex> vertexList = new ArrayList<Vertex>();
            for (int vId = 0; vId < coordinates.length - 1; ++vId) {
                vertexList.add(this.addCoordinate(coordinates[vId], buildingId));
            }
            PolygonConstraint polygonConstraint = new PolygonConstraint(vertexList);
            polygonConstraint.complete();
            if (polygonConstraint.isValid()) {
                this.constraints.add((IConstraint)polygonConstraint);
                this.constraintIndex.add(buildingId);
            }
        }
        int holeCount = newPoly.getNumInteriorRing();
        for (int holeIndex = 0; holeIndex < holeCount; ++holeIndex) {
            LinearRing holeLine = newPoly.getInteriorRingN(holeIndex);
            Coordinate[] hCoordinates = holeLine.getCoordinates();
            if (Orientation.isCCW((Coordinate[])hCoordinates)) {
                CoordinateArrays.reverse((Coordinate[])hCoordinates);
            }
            ArrayList<Vertex> vertexList = new ArrayList<Vertex>(hCoordinates.length);
            for (int vId = 0; vId < hCoordinates.length - 1; ++vId) {
                vertexList.add(this.addCoordinate(hCoordinates[vId], buildingId));
            }
            PolygonConstraint polygonConstraint = new PolygonConstraint(vertexList);
            polygonConstraint.complete();
            if (!polygonConstraint.isValid()) continue;
            this.constraints.add((IConstraint)polygonConstraint);
            this.constraintIndex.add(buildingId);
        }
    }

    @Override
    public void setMinAngle(Double minAngle) {
    }

    @Override
    public void hintInit(Envelope bBox, long polygonCount, long verticesCount) throws LayerDelaunayError {
    }

    @Override
    public List<Coordinate> getVertices() throws LayerDelaunayError {
        return this.vertices;
    }

    @Override
    public List<Triangle> getTriangles() throws LayerDelaunayError {
        return this.triangles;
    }

    private static Coordinate toCoordinate(Vertex v) {
        return new Coordinate(v.getX(), v.getY(), v.getZ());
    }

    @Override
    public void addVertex(Coordinate vertexCoordinate) throws LayerDelaunayError {
        this.addCoordinate(vertexCoordinate, 0);
    }

    @Override
    public void setMaxArea(Double maxArea) throws LayerDelaunayError {
        this.maxArea = Math.max(0.0, maxArea);
    }

    @Override
    public void addLineString(LineString lineToProcess, int buildingID) throws LayerDelaunayError {
        Coordinate[] coordinates = lineToProcess.getCoordinates();
        ArrayList<Vertex> vertexList = new ArrayList<Vertex>();
        for (Coordinate coordinate : coordinates) {
            vertexList.add(this.addCoordinate(coordinate, buildingID));
        }
        LinearConstraint linearConstraint = new LinearConstraint(vertexList);
        linearConstraint.complete();
        if (linearConstraint.isValid()) {
            this.constraints.add((IConstraint)linearConstraint);
            this.constraintIndex.add(buildingID);
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public List<Triangle> getNeighbors() throws LayerDelaunayError {
        if (this.computeNeighbors) {
            return this.neighbors;
        }
        throw new LayerDelaunayError("You must call setRetrieveNeighbors(True) before process delaunay triangulation");
    }

    @Override
    public void setRetrieveNeighbors(boolean retrieve) {
        this.computeNeighbors = retrieve;
    }
}

