/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Line;
import org.apache.commons.math3.geometry.euclidean.threed.Plane;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.locationtech.jts.algorithm.CGAlgorithms3D;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.algorithm.Length;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.triangulate.quadedge.Vertex;
import org.noise_planet.noisemodelling.pathfinder.CutPlaneVisitor;
import org.noise_planet.noisemodelling.pathfinder.CutPlaneVisitorFactory;
import org.noise_planet.noisemodelling.pathfinder.ThreadPathFinder;
import org.noise_planet.noisemodelling.pathfinder.ThreadPool;
import org.noise_planet.noisemodelling.pathfinder.path.MirrorReceiver;
import org.noise_planet.noisemodelling.pathfinder.path.MirrorReceiversCompute;
import org.noise_planet.noisemodelling.pathfinder.path.Scene;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.Building;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.BuildingIntersectionPathVisitor;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPoint;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointReceiver;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointReflection;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointSource;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointVEdgeDiffraction;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutProfile;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.ProfileBuilder;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.Wall;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.JTSUtility;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.Orientation;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.ProfilerThread;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.ReceiverStatsMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathFinder {
    private static final double NAVIGATION_POINT_DISTANCE_FROM_WALLS = 0.001;
    private static final double epsilon = 1.0E-7;
    private static final double MAX_RATIO_HULL_DIRECT_PATH = 4.0;
    public static final Logger LOGGER = LoggerFactory.getLogger(PathFinder.class);
    public ProgressVisitor progressVisitor;
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    private final Scene data;
    private int threadCount;
    private ProfilerThread profilerThread;

    public Scene getData() {
        return this.data;
    }

    public PathFinder(Scene data, ProgressVisitor progressVisitor) {
        this.data = data;
        this.threadCount = Runtime.getRuntime().availableProcessors();
        this.progressVisitor = progressVisitor;
    }

    public PathFinder(Scene data) {
        this.data = data;
        this.threadCount = Runtime.getRuntime().availableProcessors();
        this.progressVisitor = new EmptyProgressVisitor();
    }

    public ProfilerThread getProfilerThread() {
        return this.profilerThread;
    }

    public void setProfilerThread(ProfilerThread profilerThread) {
        this.profilerThread = profilerThread;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public void run(CutPlaneVisitorFactory computeRaysOut) {
        EmptyProgressVisitor cellProgress;
        ThreadPool threadManager = new ThreadPool(this.threadCount, this.threadCount + 1, Long.MAX_VALUE, TimeUnit.SECONDS);
        int maximumReceiverBatch = (int)Math.ceil((double)this.data.receivers.size() / (double)this.threadCount);
        int endReceiverRange = 0;
        ArrayList<Future<Boolean>> tasks = new ArrayList<Future<Boolean>>();
        Object object = cellProgress = this.progressVisitor == null ? new EmptyProgressVisitor() : this.progressVisitor.subProcess(this.data.receivers.size());
        while (endReceiverRange < this.data.receivers.size() && !cellProgress.isCanceled()) {
            int newEndReceiver = Math.min(endReceiverRange + maximumReceiverBatch, this.data.receivers.size());
            ThreadPathFinder threadPathFinder = new ThreadPathFinder(endReceiverRange, newEndReceiver, this, (ProgressVisitor)cellProgress, computeRaysOut.subProcess((ProgressVisitor)cellProgress), this.data);
            if (this.threadCount != 1) {
                tasks.add(threadManager.submitBlocking(threadPathFinder));
            } else {
                try {
                    threadPathFinder.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            endReceiverRange = newEndReceiver;
        }
        threadManager.shutdown();
        try {
            if (!threadManager.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS)) {
                LOGGER.warn("Timeout elapsed before termination.");
            }
        }
        catch (InterruptedException ex) {
            LOGGER.error(ex.getLocalizedMessage(), (Throwable)ex);
        }
        for (Future future : tasks) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void computeRaysAtPosition(ReceiverPointInfo receiverPointInfo, CutPlaneVisitor dataOut, ProgressVisitor visitor) {
        long start = 0L;
        if (this.profilerThread != null) {
            start = System.nanoTime();
        }
        MirrorReceiversCompute receiverMirrorIndex = null;
        long reflectionPreprocessTime = 0L;
        if (this.data.reflexionOrder > 0) {
            Envelope receiverPropagationEnvelope = new Envelope(receiverPointInfo.getCoordinates());
            receiverPropagationEnvelope.expandBy(this.data.maxSrcDist);
            List<Wall> buildWalls = this.data.profileBuilder.getWallsIn(receiverPropagationEnvelope);
            receiverMirrorIndex = new MirrorReceiversCompute(buildWalls, receiverPointInfo.position, this.data.reflexionOrder, this.data.maxSrcDist, this.data.maxRefDist);
            if (this.profilerThread != null) {
                reflectionPreprocessTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        }
        long startSourceCollect = 0L;
        if (this.profilerThread != null) {
            startSourceCollect = System.nanoTime();
        }
        double searchSourceDistance = this.data.maxSrcDist;
        Envelope receiverSourceRegion = new Envelope(receiverPointInfo.getCoordinates());
        receiverSourceRegion.expandBy(searchSourceDistance);
        Iterator<Integer> regionSourcesLst = this.data.sourcesIndex.query(receiverSourceRegion);
        ArrayList<SourcePointInfo> sourceList = new ArrayList<SourcePointInfo>();
        HashSet<Integer> processedLineSources = new HashSet<Integer>();
        while (regionSourcesLst.hasNext()) {
            Integer srcIndex = regionSourcesLst.next();
            if (processedLineSources.contains(srcIndex)) continue;
            processedLineSources.add(srcIndex);
            Geometry source = this.data.sourceGeometries.get(srcIndex);
            if (source instanceof Point) {
                Coordinate ptpos = source.getCoordinate();
                if (!(ptpos.distance(receiverPointInfo.getCoordinates()) < this.data.maxSrcDist)) continue;
                Orientation orientation = null;
                if (this.data.sourcesPk.size() > srcIndex) {
                    orientation = this.data.sourceOrientation.get(this.data.sourcesPk.get(srcIndex));
                }
                if (orientation == null) {
                    orientation = new Orientation(0.0, 0.0, 0.0);
                }
                long sourcePk = srcIndex.intValue();
                if (srcIndex < this.data.sourcesPk.size()) {
                    sourcePk = this.data.sourcesPk.get(srcIndex);
                }
                sourceList.add(new SourcePointInfo(srcIndex, sourcePk, ptpos, 1.0, orientation));
                continue;
            }
            if (source instanceof LineString) {
                this.addLineSource((LineString)source, receiverPointInfo.getCoordinates(), srcIndex, sourceList);
                continue;
            }
            if (source instanceof MultiLineString) {
                for (int id = 0; id < source.getNumGeometries(); ++id) {
                    Geometry subGeom = source.getGeometryN(id);
                    if (!(subGeom instanceof LineString)) continue;
                    this.addLineSource((LineString)subGeom, receiverPointInfo.getCoordinates(), srcIndex, sourceList);
                }
                continue;
            }
            throw new IllegalArgumentException(String.format("Sound source %s geometry are not supported", source.getGeometryType()));
        }
        sourceList.sort(Comparator.comparingDouble(o -> receiverPointInfo.position.distance3D(o.position)));
        AtomicInteger cutProfileCount = new AtomicInteger(0);
        dataOut.startReceiver(receiverPointInfo, sourceList, cutProfileCount);
        long sourceCollectTime = 0L;
        if (this.profilerThread != null) {
            sourceCollectTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startSourceCollect, TimeUnit.NANOSECONDS);
        }
        AtomicInteger processedSources = new AtomicInteger(0);
        for (SourcePointInfo sourcePointInfo : sourceList) {
            CutPlaneVisitor.PathSearchStrategy strategy = this.rcvSrcPropagation(sourcePointInfo, receiverPointInfo, dataOut, receiverMirrorIndex);
            processedSources.addAndGet(1);
            if ((visitor == null || !visitor.isCanceled()) && !strategy.equals((Object)CutPlaneVisitor.PathSearchStrategy.SKIP_RECEIVER) && !strategy.equals((Object)CutPlaneVisitor.PathSearchStrategy.PROCESS_SOURCE_BUT_SKIP_RECEIVER)) continue;
            break;
        }
        if (this.profilerThread != null && this.profilerThread.getMetric(ReceiverStatsMetric.class) != null) {
            ReceiverStatsMetric receiverStatsMetric = this.profilerThread.getMetric(ReceiverStatsMetric.class);
            receiverStatsMetric.onReceiverCutProfiles(receiverPointInfo.getId(), cutProfileCount.get(), sourceList.size(), processedSources.get());
            receiverStatsMetric.onEndComputation(new ReceiverStatsMetric.ReceiverComputationTime(receiverPointInfo.receiverIndex, (int)TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS), (int)reflectionPreprocessTime, (int)sourceCollectTime));
        }
        dataOut.finalizeReceiver(receiverPointInfo);
    }

    private CutPlaneVisitor.PathSearchStrategy rcvSrcPropagation(SourcePointInfo src, ReceiverPointInfo rcv, CutPlaneVisitor dataOut, MirrorReceiversCompute receiverMirrorIndex) {
        CutPlaneVisitor.PathSearchStrategy strategy = CutPlaneVisitor.PathSearchStrategy.CONTINUE;
        double propaDistance = src.getCoord().distance(rcv.getCoordinates());
        if (propaDistance < this.data.maxSrcDist) {
            strategy = this.directPath(src, rcv, this.data.computeVerticalDiffraction, this.data.computeHorizontalDiffraction, dataOut);
            if (strategy.equals((Object)CutPlaneVisitor.PathSearchStrategy.SKIP_SOURCE) || strategy.equals((Object)CutPlaneVisitor.PathSearchStrategy.SKIP_RECEIVER)) {
                return strategy;
            }
            if (this.data.reflexionOrder > 0) {
                strategy = this.computeReflexion(rcv, src, receiverMirrorIndex, dataOut, strategy);
            }
        }
        return strategy;
    }

    public CutPlaneVisitor.PathSearchStrategy directPath(SourcePointInfo src, ReceiverPointInfo rcv, boolean verticalDiffraction, boolean horizontalDiffraction, CutPlaneVisitor dataOut) {
        CutPlaneVisitor.PathSearchStrategy strategy = CutPlaneVisitor.PathSearchStrategy.CONTINUE;
        CutProfile cutProfile = this.data.profileBuilder.getProfile(src.position, rcv.position, this.data.defaultGroundAttenuation, !verticalDiffraction);
        if (cutProfile.getSource() != null) {
            cutProfile.getSource().id = src.getSourceIndex();
            cutProfile.getSource().li = src.li;
            cutProfile.getSource().orientation = src.getOrientation();
            if (src.sourceIndex >= 0 && src.sourceIndex < this.data.sourcesPk.size()) {
                cutProfile.getSource().sourcePk = this.data.sourcesPk.get(src.getSourceIndex());
            }
        }
        if (cutProfile.getReceiver() != null) {
            cutProfile.getReceiver().id = rcv.getId();
            cutProfile.getReceiver().receiverPk = rcv.receiverPk;
        }
        if ((verticalDiffraction || cutProfile.isFreeField()) && ((strategy = dataOut.onNewCutPlane(cutProfile)).equals((Object)CutPlaneVisitor.PathSearchStrategy.SKIP_SOURCE) || strategy.equals((Object)CutPlaneVisitor.PathSearchStrategy.SKIP_RECEIVER))) {
            return strategy;
        }
        if (horizontalDiffraction && !cutProfile.isFreeField()) {
            for (boolean curved : new boolean[]{false, true}) {
                for (ComputationSide side : ComputationSide.values()) {
                    CutProfile cutProfileSide = this.computeVEdgeDiffraction(rcv, src, this.data, side, curved);
                    if (cutProfileSide == null || !(strategy = dataOut.onNewCutPlane(cutProfileSide)).equals((Object)CutPlaneVisitor.PathSearchStrategy.SKIP_SOURCE) && !strategy.equals((Object)CutPlaneVisitor.PathSearchStrategy.SKIP_RECEIVER)) continue;
                    return strategy;
                }
            }
        }
        return strategy;
    }

    public CutProfile computeVEdgeDiffraction(ReceiverPointInfo rcv, SourcePointInfo src, Scene data, ComputationSide side, boolean curved) {
        List<Coordinate> coordinates = this.computeSideHull(side == ComputationSide.LEFT, new Coordinate(src.position), new Coordinate(rcv.position), curved);
        ArrayList<CutPoint> cutPoints = new ArrayList<CutPoint>();
        if (coordinates.size() > 2) {
            for (int i = 0; i < coordinates.size() - 1; ++i) {
                CutProfile profile = data.profileBuilder.getProfile(coordinates.get(i), coordinates.get(i + 1), data.defaultGroundAttenuation, false);
                if (i > 0) {
                    cutPoints.add(new CutPointVEdgeDiffraction(profile.getSource()));
                } else {
                    profile.getSource().id = src.sourceIndex;
                    cutPoints.add(profile.getSource());
                }
                cutPoints.addAll(profile.cutPoints.subList(1, profile.cutPoints.size() - 1));
                if (i + 1 != coordinates.size() - 1) continue;
                profile.getReceiver().id = rcv.receiverIndex;
                cutPoints.add(profile.getReceiver());
            }
            CutProfile mainProfile = this.resetSourceReceiverAttributes(rcv, src, data, cutPoints);
            mainProfile.setCurvedPath(curved);
            mainProfile.setProfileType(side == ComputationSide.LEFT ? CutProfile.PROFILE_TYPE.LEFT : CutProfile.PROFILE_TYPE.RIGHT);
            return mainProfile;
        }
        return null;
    }

    private CutProfile resetSourceReceiverAttributes(ReceiverPointInfo rcv, SourcePointInfo src, Scene data, List<CutPoint> cutPoints) {
        CutProfile mainProfile = new CutProfile((CutPointSource)cutPoints.get(0), (CutPointReceiver)cutPoints.get(cutPoints.size() - 1));
        mainProfile.insertCutPoint(false, (CutPoint[])cutPoints.subList(1, cutPoints.size() - 1).toArray(CutPoint[]::new));
        mainProfile.getReceiver().id = rcv.receiverIndex;
        mainProfile.getReceiver().receiverPk = rcv.receiverPk;
        mainProfile.getSource().id = src.sourceIndex;
        if (src.sourceIndex >= 0 && src.sourceIndex < data.sourcesPk.size()) {
            mainProfile.getSource().sourcePk = data.sourcesPk.get(src.sourceIndex);
        }
        mainProfile.getSource().orientation = src.orientation;
        mainProfile.getSource().li = src.li;
        return mainProfile;
    }

    public List<Coordinate> computeSideHull(boolean left, Coordinate p1, Coordinate p2) {
        return this.computeSideHull(left, p1, p2, false);
    }

    public List<Coordinate> computeSideHull(boolean left, Coordinate p1, Coordinate p2, boolean curved) {
        if (p1.equals((Object)p2)) {
            return new ArrayList<Coordinate>();
        }
        HashSet<LineSegment> freeFieldSegments = new HashSet<LineSegment>();
        ArrayList<Coordinate> input = new ArrayList<Coordinate>();
        Coordinate[] coordinates = new Coordinate[]{};
        int indexp1 = 0;
        int indexp2 = 0;
        boolean convexHullIntersects = true;
        input.add(p1);
        input.add(p2);
        Plane cutPlane = PathFinder.computeZeroRadPlane(p1, p2);
        BuildingIntersectionPathVisitor buildingIntersectionPathVisitor = new BuildingIntersectionPathVisitor(p1, p2, left, this.data.profileBuilder, input, cutPlane);
        buildingIntersectionPathVisitor.setCurved(curved);
        this.data.profileBuilder.getWallsOnPath(p1, p2, buildingIntersectionPathVisitor);
        block0: while (convexHullIntersects) {
            ConvexHull convexHull = new ConvexHull(input.toArray(new Coordinate[0]), GEOMETRY_FACTORY);
            Geometry convexhull = convexHull.getConvexHull();
            coordinates = convexhull.getCoordinates();
            double convexHullLength = Length.ofLine((CoordinateSequence)CoordinateArraySequenceFactory.instance().create(Arrays.copyOfRange(coordinates, 0, coordinates.length - 1)));
            if (convexHullLength / p1.distance(p2) > 4.0 || convexHullLength >= this.data.maxSrcDist) {
                return new ArrayList<Coordinate>();
            }
            convexHullIntersects = false;
            input.clear();
            input.addAll(Arrays.asList(coordinates));
            indexp1 = -1;
            for (int i = 0; i < coordinates.length - 1; ++i) {
                if (!coordinates[i].equals((Object)p1)) continue;
                indexp1 = i;
                break;
            }
            if (indexp1 == -1) {
                return new ArrayList<Coordinate>();
            }
            Coordinate[] coordinatesShifted = new Coordinate[coordinates.length];
            int len = coordinates.length - 1 - indexp1;
            System.arraycopy(coordinates, indexp1, coordinatesShifted, 0, len);
            System.arraycopy(coordinates, 0, coordinatesShifted, len, coordinates.length - len - 1);
            coordinatesShifted[coordinatesShifted.length - 1] = coordinatesShifted[0];
            coordinates = coordinatesShifted;
            indexp1 = 0;
            indexp2 = -1;
            for (int i = 1; i < coordinates.length - 1; ++i) {
                if (!coordinates[i].equals((Object)p2)) continue;
                indexp2 = i;
                break;
            }
            if (indexp2 == -1) {
                return new ArrayList<Coordinate>();
            }
            for (int k = 0; k < coordinates.length - 1; ++k) {
                LineSegment freeFieldTestSegment = new LineSegment(coordinates[k], coordinates[k + 1]);
                if ((!left || k >= indexp2) && (left || k < indexp2) || freeFieldSegments.contains(freeFieldTestSegment)) continue;
                int inputPointsBefore = input.size();
                this.data.profileBuilder.getWallsOnPath(coordinates[k], coordinates[k + 1], buildingIntersectionPathVisitor);
                if (inputPointsBefore == input.size()) {
                    freeFieldSegments.add(freeFieldTestSegment);
                    continue;
                }
                convexHullIntersects = true;
                continue block0;
            }
        }
        if (left) {
            return Arrays.asList(Arrays.copyOfRange(coordinates, indexp1, indexp2 + 1));
        }
        List<Coordinate> inversePath = Arrays.asList(Arrays.copyOfRange(coordinates, indexp2, coordinates.length));
        Collections.reverse(inversePath);
        return inversePath;
    }

    public static Plane computeZeroRadPlane(Coordinate p0, Coordinate p1) {
        Vector3D r = new Vector3D(p1.x, p1.y, p1.z);
        Vector3D s = new Vector3D(p0.x, p0.y, p0.z);
        double angle = Math.atan2(p1.y - p0.y, p1.x - p0.x);
        Vector3D rPrime = s.add((Vector)new Vector3D(Math.cos(angle - 1.5707963267948966), Math.sin(angle - 1.5707963267948966), 0.0));
        Plane p = new Plane(r, s, rPrime, 1.0E-6);
        if (p.getNormal().getZ() < 0.0) {
            p.revertSelf();
        }
        return p;
    }

    public static List<Coordinate> filterPointsBySide(LineSegment sr, boolean left, List<Coordinate> segmentsCoordinates) {
        ArrayList<Coordinate> keptSegments = new ArrayList<Coordinate>(segmentsCoordinates.size());
        for (Coordinate vertex : segmentsCoordinates) {
            int orientationIndex = sr.orientationIndex(vertex);
            if ((orientationIndex != 1 || !left) && (orientationIndex != -1 || left)) continue;
            keptSegments.add(vertex);
        }
        return keptSegments;
    }

    public static List<Coordinate> cutRoofPointsWithPlane(Plane plane, List<Coordinate> roofPts) {
        ArrayList<Coordinate> polyCut = new ArrayList<Coordinate>(roofPts.size());
        double lastOffset = 0.0;
        Coordinate cPrev = null;
        for (Coordinate cCur : roofPts) {
            Vector3D i;
            double offset = plane.getOffset((Vector)PathFinder.coordinateToVector(cCur));
            if (cPrev != null && (offset >= 0.0 && lastOffset < 0.0 || offset < 0.0 && lastOffset >= 0.0)) {
                i = plane.intersection(new Line(PathFinder.coordinateToVector(cPrev), PathFinder.coordinateToVector(cCur), 1.0E-7));
                polyCut.add(new Coordinate(i.getX(), i.getY(), i.getZ()));
            }
            if (offset >= 0.0 && (i = plane.intersection(new Line(new Vector3D(cCur.x, cCur.y, Double.MIN_VALUE), PathFinder.coordinateToVector(cCur), 1.0E-7))) != null) {
                polyCut.add(new Coordinate(i.getX(), i.getY(), i.getZ()));
            }
            lastOffset = offset;
            cPrev = cCur;
        }
        return polyCut;
    }

    public static Vector3D coordinateToVector(Coordinate p) {
        return new Vector3D(p.x, p.y, p.z);
    }

    private void insertReflectionPointAttributes(CutPoint sourceOrReceiverPoint, List<CutPoint> mainProfileCutPoints, MirrorReceiver mirrorReceiver) {
        CutPointReflection reflectionPoint = new CutPointReflection(sourceOrReceiverPoint, mirrorReceiver.getWall().getLineSegment(), mirrorReceiver.getWall().getAlphas());
        if (mirrorReceiver.wall.primaryKey >= 0L) {
            reflectionPoint.wallPk = mirrorReceiver.wall.primaryKey;
        }
        mainProfileCutPoints.add(reflectionPoint);
    }

    public CutPlaneVisitor.PathSearchStrategy computeReflexion(ReceiverPointInfo rcv, SourcePointInfo src, MirrorReceiversCompute receiverMirrorIndex, CutPlaneVisitor dataOut, CutPlaneVisitor.PathSearchStrategy initialStrategy) {
        CutPlaneVisitor.PathSearchStrategy strategy = initialStrategy;
        RobustLineIntersector linters = new RobustLineIntersector();
        List<MirrorReceiver> mirrorResults = receiverMirrorIndex.findCloseMirrorReceivers(src.position);
        for (MirrorReceiver receiverReflection : mirrorResults) {
            Coordinate reflectionPt;
            Wall seg = receiverReflection.getWall();
            ArrayList<MirrorReceiver> rayPath = new ArrayList<MirrorReceiver>();
            MirrorReceiver receiverReflectionCursor = receiverReflection;
            Coordinate destinationPt = new Coordinate(src.position);
            linters.computeIntersection(seg.p0, seg.p1, receiverReflection.getReceiverPos(), destinationPt);
            while (linters.hasIntersection() && !(reflectionPt = new Coordinate(linters.getIntersection(0))).equals((Object)destinationPt)) {
                Coordinate vec_epsilon = new Coordinate(reflectionPt.x - destinationPt.x, reflectionPt.y - destinationPt.y);
                double length = vec_epsilon.distance(new Coordinate(0.0, 0.0, 0.0));
                vec_epsilon.x /= length;
                vec_epsilon.y /= length;
                vec_epsilon.x *= 0.001;
                vec_epsilon.y *= 0.001;
                reflectionPt.x -= vec_epsilon.x;
                reflectionPt.y -= vec_epsilon.y;
                reflectionPt.setOrdinate(2, Vertex.interpolateZ((Coordinate)linters.getIntersection(0), (Coordinate)receiverReflectionCursor.getReceiverPos(), (Coordinate)destinationPt));
                MirrorReceiver reflResult = new MirrorReceiver(receiverReflectionCursor);
                reflResult.setReflectionPosition(reflectionPt);
                rayPath.add(reflResult);
                if (receiverReflectionCursor.getParentMirror() == null) break;
                destinationPt.setCoordinate(reflectionPt);
                receiverReflectionCursor = receiverReflectionCursor.getParentMirror();
                seg = receiverReflectionCursor.getWall();
                linters.computeIntersection(seg.p0, seg.p1, receiverReflectionCursor.getReceiverPos(), destinationPt);
            }
            CutProfile segmentCutProfile = this.data.profileBuilder.getProfile(src.position, ((MirrorReceiver)rayPath.get(0)).getReflectionPosition(), this.data.defaultGroundAttenuation, !this.data.computeVerticalDiffraction);
            if (!segmentCutProfile.isFreeField() && !this.data.computeVerticalDiffraction) continue;
            ArrayList<CutPoint> mainProfileCutPoints = new ArrayList<CutPoint>(segmentCutProfile.cutPoints.subList(0, segmentCutProfile.cutPoints.size() - 1));
            boolean validReflection = true;
            for (int idPt = 0; idPt < rayPath.size() - 1; ++idPt) {
                MirrorReceiver firstPoint = (MirrorReceiver)rayPath.get(idPt);
                MirrorReceiver secondPoint = (MirrorReceiver)rayPath.get(idPt + 1);
                segmentCutProfile = this.data.profileBuilder.getProfile(firstPoint.getReflectionPosition(), secondPoint.getReflectionPosition(), this.data.defaultGroundAttenuation, !this.data.computeVerticalDiffraction);
                if (!segmentCutProfile.isFreeField() && !this.data.computeVerticalDiffraction) continue;
                if (!segmentCutProfile.isFreeField() && !this.data.computeVerticalDiffraction) {
                    validReflection = false;
                    break;
                }
                this.insertReflectionPointAttributes(segmentCutProfile.cutPoints.get(0), mainProfileCutPoints, firstPoint);
                mainProfileCutPoints.addAll(segmentCutProfile.cutPoints.subList(1, segmentCutProfile.cutPoints.size() - 1));
            }
            if (!validReflection) continue;
            segmentCutProfile = this.data.profileBuilder.getProfile(((MirrorReceiver)rayPath.get(rayPath.size() - 1)).getReflectionPosition(), rcv.position, this.data.defaultGroundAttenuation, !this.data.computeVerticalDiffraction);
            if (!segmentCutProfile.isFreeField() && !this.data.computeVerticalDiffraction) continue;
            this.insertReflectionPointAttributes(segmentCutProfile.cutPoints.get(0), mainProfileCutPoints, (MirrorReceiver)rayPath.get(rayPath.size() - 1));
            mainProfileCutPoints.addAll(segmentCutProfile.cutPoints.subList(1, segmentCutProfile.cutPoints.size()));
            CutProfile cutProfileReflexion = this.resetSourceReceiverAttributes(rcv, src, this.data, mainProfileCutPoints);
            cutProfileReflexion.setProfileType(CutProfile.PROFILE_TYPE.REFLECTION);
            strategy = dataOut.onNewCutPlane(cutProfileReflexion);
            if (!strategy.equals((Object)CutPlaneVisitor.PathSearchStrategy.SKIP_SOURCE) && !strategy.equals((Object)CutPlaneVisitor.PathSearchStrategy.SKIP_RECEIVER)) continue;
            return strategy;
        }
        return strategy;
    }

    public static double splitLineStringIntoPoints(LineString geom, double segmentSizeConstraint, List<Coordinate> pts) {
        double geomLength = geom.getLength();
        if (geomLength < segmentSizeConstraint) {
            Coordinate[] points = geom.getCoordinates();
            double segmentLength = 0.0;
            double targetSegmentSize = geomLength / 2.0;
            for (int i = 0; i < points.length - 1; ++i) {
                Coordinate a = points[i];
                Coordinate b = points[i + 1];
                double length = a.distance3D(b);
                if (length + segmentLength > targetSegmentSize) {
                    double segmentLengthFraction = (targetSegmentSize - segmentLength) / length;
                    Coordinate midPoint = new Coordinate(a.x + segmentLengthFraction * (b.x - a.x), a.y + segmentLengthFraction * (b.y - a.y), a.z + segmentLengthFraction * (b.z - a.z));
                    pts.add(midPoint);
                    break;
                }
                segmentLength += length;
            }
            return geom.getLength();
        }
        double targetSegmentSize = geomLength / Math.ceil(geomLength / segmentSizeConstraint);
        Coordinate[] points = geom.getCoordinates();
        double segmentLength = 0.0;
        Coordinate midPoint = null;
        for (int i = 0; i < points.length - 1; ++i) {
            double segmentLengthFraction;
            Coordinate a = points[i];
            Coordinate b = points[i + 1];
            double length = a.distance3D(b);
            if (Double.isNaN(length)) {
                length = a.distance(b);
            }
            while (length + segmentLength > targetSegmentSize) {
                segmentLengthFraction = (targetSegmentSize - segmentLength) / length;
                Coordinate splitPoint = new Coordinate();
                splitPoint.x = a.x + segmentLengthFraction * (b.x - a.x);
                splitPoint.y = a.y + segmentLengthFraction * (b.y - a.y);
                splitPoint.z = a.z + segmentLengthFraction * (b.z - a.z);
                if (midPoint == null && length + segmentLength > targetSegmentSize / 2.0) {
                    segmentLengthFraction = (targetSegmentSize / 2.0 - segmentLength) / length;
                    midPoint = new Coordinate(a.x + segmentLengthFraction * (b.x - a.x), a.y + segmentLengthFraction * (b.y - a.y), a.z + segmentLengthFraction * (b.z - a.z));
                }
                pts.add(midPoint);
                a = splitPoint;
                length = a.distance3D(b);
                if (Double.isNaN(length)) {
                    length = a.distance(b);
                }
                segmentLength = 0.0;
                midPoint = null;
            }
            if (midPoint == null && length + segmentLength > targetSegmentSize / 2.0) {
                segmentLengthFraction = (targetSegmentSize / 2.0 - segmentLength) / length;
                midPoint = new Coordinate(a.x + segmentLengthFraction * (b.x - a.x), a.y + segmentLengthFraction * (b.y - a.y), a.z + segmentLengthFraction * (b.z - a.z));
            }
            segmentLength += length;
        }
        if (midPoint != null) {
            pts.add(midPoint);
        }
        return targetSegmentSize;
    }

    private static LineString splitLineSource(LineString lineString, ProfileBuilder profileBuilder, double epsilon) {
        boolean warned = false;
        ArrayList<Coordinate> newGeomCoordinates = new ArrayList<Coordinate>();
        Coordinate[] coordinates = lineString.getCoordinates();
        for (int idPoint = 0; idPoint < coordinates.length - 1; ++idPoint) {
            Coordinate p0 = coordinates[idPoint];
            Coordinate p1 = coordinates[idPoint + 1];
            ArrayList<Coordinate> groundProfileCoordinates = new ArrayList<Coordinate>();
            profileBuilder.fetchTopographicProfile(groundProfileCoordinates, p0, p1, false);
            newGeomCoordinates.ensureCapacity(newGeomCoordinates.size() + groundProfileCoordinates.size());
            if (groundProfileCoordinates.size() < 2) {
                if (profileBuilder.hasDem() && !warned) {
                    LOGGER.warn("Source line out of DEM area {}", (Object)new WKTWriter(3).write((Geometry)lineString));
                    warned = true;
                }
                newGeomCoordinates.add(p0);
                newGeomCoordinates.add(p1);
                continue;
            }
            if (idPoint == 0) {
                newGeomCoordinates.add(new Coordinate(p0.x, p0.y, p0.z + ((Coordinate)groundProfileCoordinates.get((int)0)).z));
            }
            Coordinate previous = (Coordinate)groundProfileCoordinates.get(0);
            for (int groundPoint = 1; groundPoint < groundProfileCoordinates.size() - 1; ++groundPoint) {
                Coordinate next;
                Coordinate current = (Coordinate)groundProfileCoordinates.get(groundPoint);
                if (!(CGAlgorithms3D.distancePointSegment((Coordinate)current, (Coordinate)previous, (Coordinate)(next = (Coordinate)groundProfileCoordinates.get(groundPoint + 1))) >= epsilon)) continue;
                previous = current;
                newGeomCoordinates.add(new Coordinate(current.x, current.y, current.z + Vertex.interpolateZ((Coordinate)current, (Coordinate)p0, (Coordinate)p1)));
            }
            newGeomCoordinates.add(new Coordinate(p1.x, p1.y, p1.z + ((Coordinate)groundProfileCoordinates.get((int)(groundProfileCoordinates.size() - 1))).z));
        }
        return GEOMETRY_FACTORY.createLineString(newGeomCoordinates.toArray(new Coordinate[0]));
    }

    public void makeSourceRelativeZToAbsolute() {
        ArrayList<Geometry> sourceCopy = new ArrayList<Geometry>(this.data.sourceGeometries.size());
        for (Geometry source : this.data.sourceGeometries) {
            LineString offsetGeometry;
            if (source instanceof LineString) {
                offsetGeometry = PathFinder.splitLineSource((LineString)source, this.data.profileBuilder, 0.001);
            } else if (source instanceof MultiLineString) {
                LineString[] newGeom = new LineString[source.getNumGeometries()];
                for (int idGeom = 0; idGeom < source.getNumGeometries(); ++idGeom) {
                    newGeom[idGeom] = PathFinder.splitLineSource((LineString)source.getGeometryN(idGeom), this.data.profileBuilder, 0.001);
                }
                offsetGeometry = GEOMETRY_FACTORY.createMultiLineString(newGeom);
            } else if (source instanceof Point) {
                Coordinate sourceCoord = source.getCoordinate();
                offsetGeometry = GEOMETRY_FACTORY.createPoint(new Coordinate(sourceCoord.x, sourceCoord.y, sourceCoord.z + this.data.profileBuilder.getZGround(sourceCoord)));
                Building building = this.data.profileBuilder.getBuildingAtCoordinate(sourceCoord);
                if (building != null && building.getHeight() >= sourceCoord.z) {
                    LOGGER.warn("Point source has been ignored as it is inside a building (building height {} m), it should be moved higher SOURCE: {}", (Object)building.getHeight(), (Object)new WKTWriter(3).write(source));
                    continue;
                }
            } else {
                throw new IllegalArgumentException("Unsupported source geometry " + source.getGeometryType());
            }
            sourceCopy.add((Geometry)offsetGeometry);
        }
        this.data.setSources(sourceCopy);
    }

    public void makeRelativeZToAbsolute() {
        this.makeSourceRelativeZToAbsolute();
        this.makeReceiverRelativeZToAbsolute();
    }

    public void makeReceiverRelativeZToAbsolute() {
        for (Coordinate receiver : this.data.receivers) {
            receiver.setZ(receiver.getZ() + this.data.profileBuilder.getZGround(receiver));
        }
    }

    private void addLineSource(LineString source, Coordinate receiverCoord, int srcIndex, List<SourcePointInfo> sourceList) {
        ArrayList<Coordinate> pts = new ArrayList<Coordinate>();
        Coordinate nearestPoint = JTSUtility.getNearestPoint(receiverCoord, source);
        double segmentSizeConstraint = Math.max(1.0, receiverCoord.distance3D(nearestPoint) / 2.0);
        if (Double.isNaN(segmentSizeConstraint)) {
            segmentSizeConstraint = Math.max(1.0, receiverCoord.distance(nearestPoint) / 2.0);
        }
        double li = PathFinder.splitLineStringIntoPoints(source, segmentSizeConstraint, pts);
        for (int ptIndex = 0; ptIndex < pts.size(); ++ptIndex) {
            Orientation orientation;
            Coordinate pt = pts.get(ptIndex);
            if (!(pt.distance(receiverCoord) < this.data.maxSrcDist)) continue;
            org.locationtech.jts.math.Vector3D v = ptIndex == 0 ? new org.locationtech.jts.math.Vector3D(source.getCoordinates()[0], pts.get(ptIndex)) : new org.locationtech.jts.math.Vector3D(pts.get(ptIndex - 1), pts.get(ptIndex));
            if (this.data.sourcesPk.size() > srcIndex && this.data.sourceOrientation.containsKey(this.data.sourcesPk.get(srcIndex))) {
                orientation = this.data.sourceOrientation.get(this.data.sourcesPk.get(srcIndex));
                orientation = Orientation.fromVector(Orientation.rotate(new Orientation(orientation.yaw, orientation.roll, 0.0), v.normalize()), orientation.roll);
            } else {
                orientation = Orientation.fromVector(Orientation.rotate(new Orientation(0.0, 0.0, 0.0), v.normalize()), 0.0);
            }
            long sourcePk = srcIndex;
            if (srcIndex < this.data.sourcesPk.size()) {
                sourcePk = this.data.sourcesPk.get(srcIndex);
            }
            sourceList.add(new SourcePointInfo(srcIndex, sourcePk, pt, li, orientation));
        }
    }

    public static final class SourcePointInfo
    implements Comparable<SourcePointInfo> {
        public double li = -1.0;
        public int sourceIndex = -1;
        public long sourcePk = -1L;
        public Coordinate position = new Coordinate();
        public Orientation orientation = new Orientation();

        public SourcePointInfo() {
        }

        public SourcePointInfo(int sourceIndex, long sourcePrimaryKey, Coordinate position, double li, Orientation orientation) {
            this.sourceIndex = sourceIndex;
            this.sourcePk = sourcePrimaryKey;
            this.position = position;
            if (Double.isNaN(position.z)) {
                this.position = new Coordinate(position.x, position.y, 0.0);
            }
            this.li = li;
            this.orientation = orientation;
        }

        public SourcePointInfo(CutPointSource source) {
            this.sourceIndex = source.id;
            this.sourcePk = source.sourcePk;
            this.position = source.coordinate;
            this.li = source.li;
            this.orientation = source.orientation;
        }

        public Orientation getOrientation() {
            return this.orientation;
        }

        public Coordinate getCoord() {
            return this.position;
        }

        public int getSourceIndex() {
            return this.sourceIndex;
        }

        public long getSourcePk() {
            return this.sourcePk;
        }

        @Override
        public int compareTo(SourcePointInfo sourcePointInfo) {
            return Integer.compare(this.sourceIndex, sourcePointInfo.sourceIndex);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourcePointInfo that = (SourcePointInfo)o;
            return this.sourceIndex == that.sourceIndex && this.position.equals((Object)that.position);
        }

        public int hashCode() {
            int result = this.sourceIndex;
            result = 31 * result + this.position.hashCode();
            return result;
        }
    }

    public static final class ReceiverPointInfo {
        public int receiverIndex;
        public long receiverPk;
        public Coordinate position;

        public ReceiverPointInfo(int receiverIndex, long receiverPk, Coordinate position) {
            this.receiverIndex = receiverIndex;
            this.receiverPk = receiverPk;
            this.position = position;
        }

        public ReceiverPointInfo(CutPointReceiver receiver) {
            this.receiverIndex = receiver.id;
            this.receiverPk = receiver.receiverPk;
            this.position = receiver.coordinate;
        }

        public Coordinate getCoordinates() {
            return this.position;
        }

        public long getReceiverPk() {
            return this.receiverPk;
        }

        public int getId() {
            return this.receiverIndex;
        }
    }

    public static enum ComputationSide {
        LEFT,
        RIGHT;

    }
}

