/*
 * Decompiled with CFR 0.152.
 */
package org.nmdp.gl.service.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
final class JdbcUtils {
    private static final Logger logger = LoggerFactory.getLogger(JdbcUtils.class);

    JdbcUtils() {
    }

    static final byte[] hash(String value) {
        return DigestUtils.sha256((String)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final byte[] serialize(Object value) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(buffer);
            out.writeObject(value);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("could not serialize value {}, caught", value, (Object)e.getMessage());
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
        return buffer.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Object deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object object = in.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            logger.error("could not deserialize value", (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("could not deserialize value", (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        return null;
    }
}

