/*
 * Decompiled with CFR 0.152.
 */
package org.nmdp.gl.service.jdbc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.jolbox.bonecp.BoneCPDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.sql.DataSource;
import org.nmdp.gl.Allele;
import org.nmdp.gl.Locus;
import org.nmdp.gl.service.GlRegistry;
import org.nmdp.gl.service.GlstringResolver;
import org.nmdp.gl.service.IdResolver;
import org.nmdp.gl.service.jdbc.JdbcGlRegistry;
import org.nmdp.gl.service.jdbc.JdbcGlstringResolver;
import org.nmdp.gl.service.jdbc.JdbcIdResolver;

public final class JdbcModule
extends AbstractModule {
    protected void configure() {
        Names.bindProperties((Binder)this.binder(), (Properties)this.loadProperties());
        this.bind(IdResolver.class).to(JdbcIdResolver.class);
        this.bind(GlstringResolver.class).to(JdbcGlstringResolver.class);
        this.bind(GlRegistry.class).to(JdbcGlRegistry.class);
    }

    @Provides
    Cache<String, String> createIdCache() {
        return CacheBuilder.newBuilder().maximumSize(10000L).build();
    }

    @Provides
    Cache<String, Locus> createLociCache() {
        return CacheBuilder.newBuilder().maximumSize(1000L).build();
    }

    @Provides
    Cache<String, Allele> createAlleleCache() {
        return CacheBuilder.newBuilder().maximumSize(10000L).build();
    }

    @Provides
    @Singleton
    DataSource createDataSource(@Named(value="jdbcDriver") String driver, @Named(value="jdbcUrl") String url, @Named(value="jdbcUsername") String username, @Named(value="jdbcPassword") String password) {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        BoneCPDataSource dataSource = new BoneCPDataSource();
        dataSource.setJdbcUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties() {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/gl-service.properties");
            properties.load(inputStream);
        }
        catch (IOException e) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {}
        }
        return properties;
    }
}

