/*
 * Decompiled with CFR 0.152.
 */
package org.nmdp.gl.service.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.inject.Inject;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.concurrent.Immutable;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.nmdp.gl.Allele;
import org.nmdp.gl.AlleleList;
import org.nmdp.gl.Genotype;
import org.nmdp.gl.GenotypeList;
import org.nmdp.gl.Haplotype;
import org.nmdp.gl.Locus;
import org.nmdp.gl.MultilocusUnphasedGenotype;
import org.nmdp.gl.service.IdResolver;
import org.nmdp.gl.service.jdbc.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
final class JdbcIdResolver
implements IdResolver {
    private final DataSource dataSource;
    private final Cache<String, Locus> loci;
    private final Cache<String, Allele> alleles;
    private static final Logger logger = LoggerFactory.getLogger(JdbcIdResolver.class);
    private static final String LOCUS_SQL = "select locus from locus where id = ?";
    private static final String ALLELE_SQL = "select allele from allele where id = ?";
    private static final String ALLELE_LIST_SQL = "select allele_list from allele_list where id = ?";
    private static final String HAPLOTYPE_SQL = "select haplotype from haplotype where id = ?";
    private static final String GENOTYPE_SQL = "select genotype from genotype where id = ?";
    private static final String GENOTYPE_LIST_SQL = "select genotype_list from genotype_list where id = ?";
    private static final String MULTILOCUS_UNPHASED_GENOTYPE_SQL = "select multilocus_unphased_genotype from multilocus_unphased_genotype where id = ?";

    @Inject
    JdbcIdResolver(DataSource dataSource, Cache<String, Locus> loci, Cache<String, Allele> alleles) {
        Preconditions.checkNotNull((Object)dataSource);
        Preconditions.checkNotNull(loci);
        Preconditions.checkNotNull(alleles);
        this.dataSource = dataSource;
        this.loci = loci;
        this.alleles = alleles;
    }

    public Locus findLocus(String id) {
        Locus locus = (Locus)this.loci.getIfPresent((Object)id);
        if (locus != null) {
            return locus;
        }
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            locus = (Locus)queryRunner.query(LOCUS_SQL, (ResultSetHandler)new LocusHandler(), new Object[]{id});
            if (locus != null) {
                this.loci.put((Object)id, (Object)locus);
            }
            return locus;
        }
        catch (SQLException e) {
            logger.warn("could not find locus for id " + id, (Throwable)e);
            return null;
        }
    }

    public Allele findAllele(String id) {
        Allele allele = (Allele)this.alleles.getIfPresent((Object)id);
        if (allele != null) {
            return allele;
        }
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            allele = (Allele)queryRunner.query(ALLELE_SQL, (ResultSetHandler)new AlleleHandler(), new Object[]{id});
            if (allele != null) {
                this.alleles.put((Object)id, (Object)allele);
            }
            return allele;
        }
        catch (SQLException e) {
            logger.warn("could not find allele for id " + id, (Throwable)e);
            return null;
        }
    }

    public AlleleList findAlleleList(String id) {
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            return (AlleleList)queryRunner.query(ALLELE_LIST_SQL, (ResultSetHandler)new AlleleListHandler(), new Object[]{id});
        }
        catch (SQLException e) {
            logger.warn("could not find allele list for id " + id, (Throwable)e);
            return null;
        }
    }

    public Haplotype findHaplotype(String id) {
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            return (Haplotype)queryRunner.query(HAPLOTYPE_SQL, (ResultSetHandler)new HaplotypeHandler(), new Object[]{id});
        }
        catch (SQLException e) {
            logger.warn("could not find haplotype for id " + id, (Throwable)e);
            return null;
        }
    }

    public Genotype findGenotype(String id) {
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            return (Genotype)queryRunner.query(GENOTYPE_SQL, (ResultSetHandler)new GenotypeHandler(), new Object[]{id});
        }
        catch (SQLException e) {
            logger.warn("could not find genotype for id " + id, (Throwable)e);
            return null;
        }
    }

    public GenotypeList findGenotypeList(String id) {
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            return (GenotypeList)queryRunner.query(GENOTYPE_LIST_SQL, (ResultSetHandler)new GenotypeListHandler(), new Object[]{id});
        }
        catch (SQLException e) {
            logger.warn("could not find genotype list for id " + id, (Throwable)e);
            return null;
        }
    }

    public MultilocusUnphasedGenotype findMultilocusUnphasedGenotype(String id) {
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            return (MultilocusUnphasedGenotype)queryRunner.query(MULTILOCUS_UNPHASED_GENOTYPE_SQL, (ResultSetHandler)new MultilocusUnphasedGenotypeHandler(), new Object[]{id});
        }
        catch (SQLException e) {
            logger.warn("could not find multilocus unphased genotype for id " + id, (Throwable)e);
            return null;
        }
    }

    static class MultilocusUnphasedGenotypeHandler
    implements ResultSetHandler<MultilocusUnphasedGenotype> {
        MultilocusUnphasedGenotypeHandler() {
        }

        public MultilocusUnphasedGenotype handle(ResultSet resultSet) throws SQLException {
            if (!resultSet.first()) {
                return null;
            }
            byte[] bytes = resultSet.getBytes(1);
            if (bytes == null) {
                logger.warn("could not deserialize multilocus unphased genotype, bytes were null");
                return null;
            }
            return (MultilocusUnphasedGenotype)JdbcUtils.deserialize(bytes);
        }
    }

    static class GenotypeListHandler
    implements ResultSetHandler<GenotypeList> {
        GenotypeListHandler() {
        }

        public GenotypeList handle(ResultSet resultSet) throws SQLException {
            if (!resultSet.first()) {
                return null;
            }
            byte[] bytes = resultSet.getBytes(1);
            if (bytes == null) {
                logger.warn("could not deserialize genotype list, bytes were null");
                return null;
            }
            return (GenotypeList)JdbcUtils.deserialize(bytes);
        }
    }

    static class GenotypeHandler
    implements ResultSetHandler<Genotype> {
        GenotypeHandler() {
        }

        public Genotype handle(ResultSet resultSet) throws SQLException {
            if (!resultSet.first()) {
                return null;
            }
            byte[] bytes = resultSet.getBytes(1);
            if (bytes == null) {
                logger.warn("could not deserialize genotype, bytes were null");
                return null;
            }
            return (Genotype)JdbcUtils.deserialize(bytes);
        }
    }

    static class HaplotypeHandler
    implements ResultSetHandler<Haplotype> {
        HaplotypeHandler() {
        }

        public Haplotype handle(ResultSet resultSet) throws SQLException {
            if (!resultSet.first()) {
                return null;
            }
            byte[] bytes = resultSet.getBytes(1);
            if (bytes == null) {
                logger.warn("could not deserialize haplotype, bytes were null");
                return null;
            }
            return (Haplotype)JdbcUtils.deserialize(bytes);
        }
    }

    static class AlleleListHandler
    implements ResultSetHandler<AlleleList> {
        AlleleListHandler() {
        }

        public AlleleList handle(ResultSet resultSet) throws SQLException {
            if (!resultSet.first()) {
                return null;
            }
            byte[] bytes = resultSet.getBytes(1);
            if (bytes == null) {
                logger.warn("could not deserialize allele list, bytes were null");
                return null;
            }
            return (AlleleList)JdbcUtils.deserialize(bytes);
        }
    }

    static class AlleleHandler
    implements ResultSetHandler<Allele> {
        AlleleHandler() {
        }

        public Allele handle(ResultSet resultSet) throws SQLException {
            if (!resultSet.first()) {
                return null;
            }
            byte[] bytes = resultSet.getBytes(1);
            if (bytes == null) {
                logger.warn("could not deserialize allele, bytes were null");
                return null;
            }
            return (Allele)JdbcUtils.deserialize(bytes);
        }
    }

    static class LocusHandler
    implements ResultSetHandler<Locus> {
        LocusHandler() {
        }

        public Locus handle(ResultSet resultSet) throws SQLException {
            if (!resultSet.first()) {
                return null;
            }
            byte[] bytes = resultSet.getBytes(1);
            if (bytes == null) {
                logger.warn("could not deserialize locus, bytes were null");
                return null;
            }
            return (Locus)JdbcUtils.deserialize(bytes);
        }
    }
}

