/*
 * Decompiled with CFR 0.152.
 */
package org.nmdp.gl.service.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.inject.Inject;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.concurrent.Immutable;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.nmdp.gl.service.GlstringResolver;
import org.nmdp.gl.service.IdSupplier;
import org.nmdp.gl.service.jdbc.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
final class JdbcGlstringResolver
implements GlstringResolver {
    private final IdSupplier idSupplier;
    private final DataSource dataSource;
    private final Cache<String, String> locusIds;
    private final Cache<String, String> alleleIds;
    private final Logger logger = LoggerFactory.getLogger(JdbcGlstringResolver.class);
    private static final String LOCUS_ID_SQL = "select id from locus_id where glstring_hash = ?";
    private static final String ALLELE_ID_SQL = "select id from allele_id where glstring_hash = ?";
    private static final String ALLELE_LIST_ID_SQL = "select id from allele_list_id where glstring_hash = ?";
    private static final String HAPLOTYPE_ID_SQL = "select id from haplotype_id where glstring_hash = ?";
    private static final String GENOTYPE_ID_SQL = "select id from genotype_id where glstring_hash = ?";
    private static final String GENOTYPE_LIST_ID_SQL = "select id from genotype_list_id where glstring_hash = ?";
    private static final String MULTILOCUS_UNPHASED_GENOTYPE_ID_SQL = "select id from multilocus_unphased_genotype_id where glstring_hash = ?";

    @Inject
    JdbcGlstringResolver(IdSupplier idSupplier, DataSource dataSource, Cache<String, String> locusIds, Cache<String, String> alleleIds) {
        Preconditions.checkNotNull((Object)idSupplier);
        Preconditions.checkNotNull((Object)dataSource);
        Preconditions.checkNotNull(locusIds);
        Preconditions.checkNotNull(alleleIds);
        this.idSupplier = idSupplier;
        this.dataSource = dataSource;
        this.locusIds = locusIds;
        this.alleleIds = alleleIds;
    }

    public String resolveLocus(final String glstring) {
        Preconditions.checkNotNull((Object)glstring);
        Preconditions.checkArgument((!glstring.isEmpty() ? 1 : 0) != 0);
        try {
            return (String)this.locusIds.get((Object)glstring, (Callable)new Callable<String>(){

                @Override
                public String call() {
                    QueryRunner queryRunner = new QueryRunner(JdbcGlstringResolver.this.dataSource);
                    try {
                        String id = (String)queryRunner.query(JdbcGlstringResolver.LOCUS_ID_SQL, (ResultSetHandler)new ScalarHandler(), new Object[]{JdbcUtils.hash(glstring)});
                        if (id != null) {
                            return id;
                        }
                    }
                    catch (SQLException e) {
                        JdbcGlstringResolver.this.logger.warn("could not resolve id for locus with glstring " + JdbcGlstringResolver.abbrev(glstring), (Throwable)e);
                    }
                    return JdbcGlstringResolver.this.idSupplier.createLocusId();
                }
            });
        }
        catch (ExecutionException e) {
            this.logger.warn("could not resolve id for locus with glstring " + JdbcGlstringResolver.abbrev(glstring), (Throwable)e);
            return this.idSupplier.createLocusId();
        }
    }

    public String resolveAllele(final String glstring) {
        Preconditions.checkNotNull((Object)glstring);
        Preconditions.checkArgument((!glstring.isEmpty() ? 1 : 0) != 0);
        try {
            return (String)this.alleleIds.get((Object)glstring, (Callable)new Callable<String>(){

                @Override
                public String call() {
                    QueryRunner queryRunner = new QueryRunner(JdbcGlstringResolver.this.dataSource);
                    try {
                        String id = (String)queryRunner.query(JdbcGlstringResolver.ALLELE_ID_SQL, (ResultSetHandler)new ScalarHandler(), new Object[]{JdbcUtils.hash(glstring)});
                        if (id != null) {
                            return id;
                        }
                    }
                    catch (SQLException e) {
                        JdbcGlstringResolver.this.logger.warn("could not resolve id for allele with glstring " + JdbcGlstringResolver.abbrev(glstring), (Throwable)e);
                    }
                    return JdbcGlstringResolver.this.idSupplier.createAlleleId();
                }
            });
        }
        catch (ExecutionException e) {
            this.logger.warn("could not resolve id for allele with glstring " + JdbcGlstringResolver.abbrev(glstring), (Throwable)e);
            return this.idSupplier.createLocusId();
        }
    }

    public String resolveAlleleList(String glstring) {
        Preconditions.checkNotNull((Object)glstring);
        Preconditions.checkArgument((!glstring.isEmpty() ? 1 : 0) != 0);
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            String id = (String)queryRunner.query(ALLELE_LIST_ID_SQL, (ResultSetHandler)new ScalarHandler(), new Object[]{JdbcUtils.hash(glstring)});
            if (id != null) {
                return id;
            }
        }
        catch (SQLException e) {
            this.logger.warn("could not resolve id for allele list with glstring " + JdbcGlstringResolver.abbrev(glstring), (Throwable)e);
        }
        return this.idSupplier.createAlleleListId();
    }

    public String resolveHaplotype(String glstring) {
        Preconditions.checkNotNull((Object)glstring);
        Preconditions.checkArgument((!glstring.isEmpty() ? 1 : 0) != 0);
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            String id = (String)queryRunner.query(HAPLOTYPE_ID_SQL, (ResultSetHandler)new ScalarHandler(), new Object[]{JdbcUtils.hash(glstring)});
            if (id != null) {
                return id;
            }
        }
        catch (SQLException e) {
            this.logger.warn("could not resolve id for haplotype with glstring " + JdbcGlstringResolver.abbrev(glstring), (Throwable)e);
        }
        return this.idSupplier.createHaplotypeId();
    }

    public String resolveGenotype(String glstring) {
        Preconditions.checkNotNull((Object)glstring);
        Preconditions.checkArgument((!glstring.isEmpty() ? 1 : 0) != 0);
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            String id = (String)queryRunner.query(GENOTYPE_ID_SQL, (ResultSetHandler)new ScalarHandler(), new Object[]{JdbcUtils.hash(glstring)});
            if (id != null) {
                return id;
            }
        }
        catch (SQLException e) {
            this.logger.warn("could not resolve id for genotype with glstring " + JdbcGlstringResolver.abbrev(glstring), (Throwable)e);
        }
        return this.idSupplier.createGenotypeId();
    }

    public String resolveGenotypeList(String glstring) {
        Preconditions.checkNotNull((Object)glstring);
        Preconditions.checkArgument((!glstring.isEmpty() ? 1 : 0) != 0);
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            String id = (String)queryRunner.query(GENOTYPE_LIST_ID_SQL, (ResultSetHandler)new ScalarHandler(), new Object[]{JdbcUtils.hash(glstring)});
            if (id != null) {
                return id;
            }
        }
        catch (SQLException e) {
            this.logger.warn("could not resolve id for genotype list with glstring " + JdbcGlstringResolver.abbrev(glstring), (Throwable)e);
        }
        return this.idSupplier.createGenotypeListId();
    }

    public String resolveMultilocusUnphasedGenotype(String glstring) {
        Preconditions.checkNotNull((Object)glstring);
        Preconditions.checkArgument((!glstring.isEmpty() ? 1 : 0) != 0);
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            String id = (String)queryRunner.query(MULTILOCUS_UNPHASED_GENOTYPE_ID_SQL, (ResultSetHandler)new ScalarHandler(), new Object[]{JdbcUtils.hash(glstring)});
            if (id != null) {
                return id;
            }
        }
        catch (SQLException e) {
            this.logger.warn("could not resolve id for multilocus unphased genotype with glstring " + JdbcGlstringResolver.abbrev(glstring), (Throwable)e);
        }
        return this.idSupplier.createMultilocusUnphasedGenotypeId();
    }

    private static String abbrev(String glstring) {
        if (glstring.length() < 64) {
            return glstring;
        }
        return glstring.substring(0, 61) + "...";
    }
}

