/*
 * Decompiled with CFR 0.152.
 */
package org.nmdp.gl.service.jdbc;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.sql.SQLException;
import javax.annotation.concurrent.Immutable;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.nmdp.gl.Allele;
import org.nmdp.gl.AlleleList;
import org.nmdp.gl.Genotype;
import org.nmdp.gl.GenotypeList;
import org.nmdp.gl.Haplotype;
import org.nmdp.gl.Locus;
import org.nmdp.gl.MultilocusUnphasedGenotype;
import org.nmdp.gl.service.GlRegistry;
import org.nmdp.gl.service.jdbc.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
final class JdbcGlRegistry
implements GlRegistry {
    private final DataSource dataSource;
    private final Logger logger = LoggerFactory.getLogger(JdbcGlRegistry.class);
    private static final String INSERT_LOCUS_SQL = "insert into locus (id, locus) values (?, ?)";
    private static final String INSERT_LOCUS_ID_SQL = "insert into locus_id (glstring, glstring_hash, id) values (?, ?, ?)";
    private static final String INSERT_ALLELE_SQL = "insert into allele (id, allele) values (?, ?)";
    private static final String INSERT_ALLELE_ID_SQL = "insert into allele_id (glstring, glstring_hash, id) values (?, ?, ?)";
    private static final String INSERT_ALLELE_LIST_SQL = "insert into allele_list (id, allele_list) values (?, ?)";
    private static final String INSERT_ALLELE_LIST_ID_SQL = "insert into allele_list_id (glstring, glstring_hash, id) values (?, ?, ?)";
    private static final String INSERT_HAPLOTYPE_SQL = "insert into haplotype (id, haplotype) values (?, ?)";
    private static final String INSERT_HAPLOTYPE_ID_SQL = "insert into haplotype_id (glstring, glstring_hash, id) values (?, ?, ?)";
    private static final String INSERT_GENOTYPE_SQL = "insert into genotype (id, genotype) values (?, ?)";
    private static final String INSERT_GENOTYPE_ID_SQL = "insert into genotype_id (glstring, glstring_hash, id) values (?, ?, ?)";
    private static final String INSERT_GENOTYPE_LIST_SQL = "insert into genotype_list (id, genotype_list) values (?, ?)";
    private static final String INSERT_GENOTYPE_LIST_ID_SQL = "insert into genotype_list_id (glstring, glstring_hash, id) values (?, ?, ?)";
    private static final String INSERT_MULTILOCUS_UNPHASED_GENOTYPE_SQL = "insert into multilocus_unphased_genotype (id, multilocus_unphased_genotype) values (?, ?)";
    private static final String INSERT_MULTILOCUS_UNPHASED_GENOTYPE_ID_SQL = "insert into multilocus_unphased_genotype_id (glstring, glstring_hash, id) values (?, ?, ?)";

    @Inject
    JdbcGlRegistry(DataSource dataSource) {
        Preconditions.checkNotNull((Object)dataSource);
        this.dataSource = dataSource;
    }

    public void registerLocus(Locus locus) {
        Preconditions.checkNotNull((Object)locus);
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            queryRunner.update(INSERT_LOCUS_SQL, new Object[]{locus.getId(), locus});
            queryRunner.update(INSERT_LOCUS_ID_SQL, new Object[]{locus.getGlstring(), JdbcUtils.hash(locus.getGlstring()), locus.getId()});
        }
        catch (SQLException e) {
            this.logger.warn("could not register locus " + locus.getId(), (Throwable)e);
        }
    }

    public void registerAllele(Allele allele) {
        Preconditions.checkNotNull((Object)allele);
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            queryRunner.update(INSERT_ALLELE_SQL, new Object[]{allele.getId(), allele});
            queryRunner.update(INSERT_ALLELE_ID_SQL, new Object[]{allele.getGlstring(), JdbcUtils.hash(allele.getGlstring()), allele.getId()});
        }
        catch (SQLException e) {
            this.logger.warn("could not register allele " + allele.getId(), (Throwable)e);
        }
    }

    public void registerAlleleList(AlleleList alleleList) {
        Preconditions.checkNotNull((Object)alleleList);
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            queryRunner.update(INSERT_ALLELE_LIST_SQL, new Object[]{alleleList.getId(), alleleList});
            queryRunner.update(INSERT_ALLELE_LIST_ID_SQL, new Object[]{alleleList.getGlstring(), JdbcUtils.hash(alleleList.getGlstring()), alleleList.getId()});
        }
        catch (SQLException e) {
            this.logger.warn("could not register allele list " + alleleList.getId(), (Throwable)e);
        }
    }

    public void registerHaplotype(Haplotype haplotype) {
        Preconditions.checkNotNull((Object)haplotype);
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            queryRunner.update(INSERT_HAPLOTYPE_SQL, new Object[]{haplotype.getId(), haplotype});
            queryRunner.update(INSERT_HAPLOTYPE_ID_SQL, new Object[]{haplotype.getGlstring(), JdbcUtils.hash(haplotype.getGlstring()), haplotype.getId()});
        }
        catch (SQLException e) {
            this.logger.warn("could not register haplotype " + haplotype.getId(), (Throwable)e);
        }
    }

    public void registerGenotype(Genotype genotype) {
        Preconditions.checkNotNull((Object)genotype);
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            queryRunner.update(INSERT_GENOTYPE_SQL, new Object[]{genotype.getId(), genotype});
            queryRunner.update(INSERT_GENOTYPE_ID_SQL, new Object[]{genotype.getGlstring(), JdbcUtils.hash(genotype.getGlstring()), genotype.getId()});
        }
        catch (SQLException e) {
            this.logger.warn("could not register genotype " + genotype.getId(), (Throwable)e);
        }
    }

    public void registerGenotypeList(GenotypeList genotypeList) {
        Preconditions.checkNotNull((Object)genotypeList);
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            queryRunner.update(INSERT_GENOTYPE_LIST_SQL, new Object[]{genotypeList.getId(), genotypeList});
            queryRunner.update(INSERT_GENOTYPE_LIST_ID_SQL, new Object[]{genotypeList.getGlstring(), JdbcUtils.hash(genotypeList.getGlstring()), genotypeList.getId()});
        }
        catch (SQLException e) {
            this.logger.warn("could not register genotype list " + genotypeList.getId(), (Throwable)e);
        }
    }

    public void registerMultilocusUnphasedGenotype(MultilocusUnphasedGenotype multilocusUnphasedGenotype) {
        Preconditions.checkNotNull((Object)multilocusUnphasedGenotype);
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        try {
            queryRunner.update(INSERT_MULTILOCUS_UNPHASED_GENOTYPE_SQL, new Object[]{multilocusUnphasedGenotype.getId(), multilocusUnphasedGenotype});
            queryRunner.update(INSERT_MULTILOCUS_UNPHASED_GENOTYPE_ID_SQL, new Object[]{multilocusUnphasedGenotype.getGlstring(), JdbcUtils.hash(multilocusUnphasedGenotype.getGlstring()), multilocusUnphasedGenotype.getId()});
        }
        catch (SQLException e) {
            this.logger.warn("could not register multilocus unphased genotype " + multilocusUnphasedGenotype.getId(), (Throwable)e);
        }
    }
}

