/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.streams;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.function.Consumer;
import org.apache.camel.ProducerTemplate;
import org.nhindirect.common.tx.model.Tx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"streams"})
public class TxEventSink {
    private static final Logger log = LoggerFactory.getLogger(TxEventSink.class);
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    protected ProducerTemplate template;

    public void setProducerTemplate(ProducerTemplate template) {
        this.template = template;
    }

    @Bean
    public Consumer<String> directTxMonitoring() throws ClassNotFoundException, JsonParseException, JsonMappingException, IOException {
        return txMarshalled -> {
            try {
                if (log.isTraceEnabled()) {
                    log.trace("Attempting to add Tx");
                }
                Tx tx = (Tx)this.objectMapper.readValue(txMarshalled, Tx.class);
                if (this.template == null) {
                    throw new IllegalStateException("Template producer cannot be null.  Please examine the txs resource configuration");
                }
                try {
                    this.template.sendBody((Object)tx);
                }
                catch (Throwable t) {
                    log.error("Failed to add Tx message", t);
                }
                if (log.isTraceEnabled()) {
                    log.trace("Tx added");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }
}

