/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.springconfig;

import javax.sql.DataSource;
import org.nhindirect.monitor.entity.Aggregation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.util.ClassUtils;

@Configuration
public class EntityManagerConfig {
    @Autowired
    protected DataSource dataSource;

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory() {
        try {
            HibernateJpaVendorAdapter jpaAdaptor = new HibernateJpaVendorAdapter();
            jpaAdaptor.setGenerateDdl(true);
            LocalContainerEntityManagerFactoryBean entityManagerFactory = new LocalContainerEntityManagerFactoryBean();
            entityManagerFactory.setDataSource(this.dataSource);
            entityManagerFactory.setPersistenceUnitName("direct-msg-monitor-store");
            entityManagerFactory.setJpaVendorAdapter((JpaVendorAdapter)jpaAdaptor);
            entityManagerFactory.setPackagesToScan(new String[]{ClassUtils.getPackageName(Aggregation.class)});
            return entityManagerFactory;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to build entity factory manager.", e);
        }
    }
}

