/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.resources;

import org.apache.camel.ProducerTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.monitor.processor.DuplicateNotificationStateManager;
import org.nhindirect.monitor.processor.DuplicateNotificationStateManagerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"txs"})
public class TxsResource {
    protected static final CacheControl noCache = CacheControl.noCache();
    private static final Log LOGGER = LogFactory.getFactory().getInstance(TxsResource.class);
    @Autowired
    protected ProducerTemplate template;
    @Autowired
    protected DuplicateNotificationStateManager dupStateManager;

    public TxsResource() {
    }

    public TxsResource(ProducerTemplate template, DuplicateNotificationStateManager dupMgr) {
        this.template = template;
        this.dupStateManager = dupMgr;
    }

    public void setProducerTemplate(ProducerTemplate template) {
        this.template = template;
    }

    @PostMapping(consumes={"application/json"})
    public ResponseEntity<Mono<Void>> addTx(@RequestBody Tx tx) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"Attempting to add Tx");
        }
        if (this.template == null) {
            throw new IllegalStateException("Template producer cannot be null.  Please examine the txs resource configuration");
        }
        try {
            this.template.sendBody((Object)tx);
        }
        catch (Throwable t) {
            LOGGER.error((Object)"Failed to add Tx message", t);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"Tx added");
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CREATED).cacheControl(noCache)).build();
    }

    @PostMapping(value={"suppressNotification"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Mono<Boolean>> supressNotification(@RequestBody Tx notificationMessage) {
        if (this.dupStateManager == null) {
            throw new IllegalStateException("Duplication state manager cannot be null.  Please examine the txs resource configuration");
        }
        try {
            Boolean retEntity = this.dupStateManager.suppressNotification(notificationMessage);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)Mono.just((Object)retEntity));
        }
        catch (DuplicateNotificationStateManagerException e) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }
}

