/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.processor.impl;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.processor.DuplicateNotificationStateManager;
import org.nhindirect.monitor.processor.DuplicateNotificationStateManagerException;
import org.nhindirect.monitor.repository.ReceivedNotificationRepository;
import org.nhindirect.monitor.repository.RepositoryBiz;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DefaultDuplicateNotificationStateManager
implements DuplicateNotificationStateManager {
    protected static final int DEFAULT_RETENTION_TIME = 7;
    @Value(value="${monitor.dupStateDAO.retensionTime:7}")
    protected int messageRetention = 7;
    @Autowired
    protected ReceivedNotificationRepository recRepo;

    public void setMessageRetention(int messageRetention) {
        this.messageRetention = messageRetention;
    }

    public void setReceivedNotificationRepository(ReceivedNotificationRepository recRepo) {
        this.recRepo = recRepo;
    }

    @Override
    public void addNotification(Tx notificationMessage) throws DuplicateNotificationStateManagerException {
        if (this.recRepo == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        if (notificationMessage == null) {
            throw new IllegalArgumentException("Notification message cannot be null");
        }
        TxMessageType type = notificationMessage.getMsgType();
        if (type == TxMessageType.DSN || type == TxMessageType.MDN) {
            TxDetail originalMessageIdDetail = notificationMessage.getDetail(TxDetailType.PARENT_MSG_ID);
            TxDetail origRecips = notificationMessage.getDetail(TxDetailType.FINAL_RECIPIENTS);
            try {
                if (originalMessageIdDetail != null && origRecips != null) {
                    for (String recipAddress : origRecips.getDetailValue().split(",")) {
                        RepositoryBiz.addMessageToDuplicateStore(originalMessageIdDetail.getDetailValue(), recipAddress, this.recRepo);
                    }
                }
            }
            catch (Exception e) {
                throw new DuplicateNotificationStateManagerException(e);
            }
        }
    }

    @Override
    public boolean suppressNotification(Tx notificationMessage) throws DuplicateNotificationStateManagerException {
        boolean retVal = false;
        if (this.recRepo == null) {
            throw new IllegalArgumentException("Dao cannot be null");
        }
        if (notificationMessage == null) {
            throw new IllegalArgumentException("Notification message cannot be null");
        }
        TxMessageType type = notificationMessage.getMsgType();
        if (type == TxMessageType.DSN || type == TxMessageType.MDN) {
            TxDetail dispositionDetail = notificationMessage.getDetail(TxDetailType.DISPOSITION);
            if (type == TxMessageType.MDN && (dispositionDetail == null || dispositionDetail.getDetailValue().contains("displayed"))) {
                return retVal;
            }
            TxDetail originalMessageIdDetail = notificationMessage.getDetail(TxDetailType.PARENT_MSG_ID);
            TxDetail origRecips = notificationMessage.getDetail(TxDetailType.FINAL_RECIPIENTS);
            if (originalMessageIdDetail != null && origRecips != null) {
                List<String> recips = Arrays.asList(origRecips.getDetailValue().split(","));
                try {
                    recips.replaceAll(String::toUpperCase);
                    List<String> alreadyReceivedNotifs = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase(originalMessageIdDetail.getDetailValue().toUpperCase(), recips);
                    if (!alreadyReceivedNotifs.isEmpty()) {
                        retVal = true;
                    }
                }
                catch (Exception e) {
                    throw new DuplicateNotificationStateManagerException(e);
                }
            }
        }
        return retVal;
    }

    @Override
    public void purge() {
        if (this.recRepo == null) {
            throw new IllegalArgumentException("Dao cannot be null");
        }
        Calendar cal = Calendar.getInstance(Locale.getDefault());
        cal.add(10, -(24 * this.messageRetention));
        this.recRepo.deleteByReceivedTimeBefore(cal);
    }
}

