/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.processor;

import javax.mail.internet.MimeMessage;
import org.apache.camel.Exchange;
import org.nhindirect.monitor.processor.DSNMailSender;
import org.nhindirect.monitor.processor.StreamsDSNMailSenderSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsDSNMailSender
implements DSNMailSender {
    private static final Logger log = LoggerFactory.getLogger(StreamsDSNMailSender.class);
    protected StreamsDSNMailSenderSource streamSource;

    public StreamsDSNMailSender(StreamsDSNMailSenderSource streamSource) {
        this.streamSource = streamSource;
    }

    @Override
    public void sendMail(Exchange exchange) throws Exception {
        if (this.streamSource == null) {
            throw new IllegalStateException("Stream source is null");
        }
        if (exchange.getIn() == null || exchange.getIn().getBody() == null) {
            return;
        }
        MimeMessage dsnMessage = (MimeMessage)exchange.getIn().getBody();
        try {
            this.streamSource.sendMimeMessage(dsnMessage);
        }
        catch (Exception e) {
            log.error("Error sending message on stream source");
            throw e;
        }
    }
}

