/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.processor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import javax.mail.internet.MimeMessage;
import org.apache.camel.Exchange;
import org.apache.camel.Handler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.smtp.SMTPClient;
import org.nhindirect.monitor.processor.DSNMailSender;
import org.nhindirect.monitor.processor.SMTPClientFactory;

public class SMTPDSNMailSender
implements DSNMailSender {
    protected static final int SMTP_OK = 250;
    protected SMTPClientFactory clientFactory;
    protected String gatewayHost;
    protected int gatewayPort = 25;
    protected String localhost = "localhost";

    public SMTPDSNMailSender() {
        try {
            this.localhost = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SMTPDSNMailSender(String gatewayURL, SMTPClientFactory clientFactory) {
        this();
        this.setSMTPClientFactory(clientFactory);
        this.setGatewayURL(gatewayURL);
    }

    public void setSMTPClientFactory(SMTPClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public void setGatewayURL(String gatewayURL) {
        try {
            URI gateway = new URI(gatewayURL);
            if (gateway.getPort() > 0) {
                this.gatewayPort = gateway.getPort();
            }
            this.gatewayHost = gateway.getHost();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid gateway URL.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Handler
    public void sendMail(Exchange exchange) throws Exception {
        String[] recips;
        if (this.gatewayHost == null || this.gatewayHost.isEmpty()) {
            throw new IllegalStateException("Gateway URL is null or empty");
        }
        if (this.clientFactory == null) {
            throw new IllegalStateException("SMTP client cannot be null");
        }
        if (exchange.getIn() == null || exchange.getIn().getBody() == null) {
            return;
        }
        MimeMessage dsnMessage = (MimeMessage)exchange.getIn().getBody();
        String recpList = dsnMessage.getHeader("to", ",");
        String sender = dsnMessage.getHeader("from", ",");
        SMTPClient client = this.clientFactory.createInstance();
        client.connect(this.gatewayHost, this.gatewayPort);
        client.helo(this.localhost);
        if (!client.setSender(sender)) {
            throw new IOException("Failed to set sender.");
        }
        for (String recip : recips = recpList.split(",")) {
            if (client.addRecipient(recip)) continue;
            throw new IOException("Failed to set recipient " + recip);
        }
        Writer writer = client.sendMessageData();
        if (writer == null) {
            throw new IOException("Failed to get data body writer.");
        }
        ByteArrayOutputStream writerStream = new ByteArrayOutputStream();
        try {
            dsnMessage.writeTo((OutputStream)writerStream);
            IOUtils.write((byte[])writerStream.toByteArray(), (Writer)writer);
            writer.close();
            client.completePendingCommand();
            if (client.getReplyCode() != 250) {
                throw new IOException("Failed complete data command with error code " + client.getReplyCode());
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)writerStream);
            IOUtils.closeQuietly((Writer)writer);
            client.quit();
            client.disconnect();
        }
    }
}

