/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.processor;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.apache.camel.Exchange;
import org.apache.camel.Handler;
import org.apache.commons.io.IOUtils;
import org.nhindirect.common.mail.dsn.DSNFailureTextBodyPartGenerator;
import org.nhindirect.common.mail.dsn.DSNGenerator;
import org.nhindirect.common.mail.dsn.DSNMessageHeaders;
import org.nhindirect.common.mail.dsn.DSNRecipientHeaders;
import org.nhindirect.common.mail.dsn.DSNStandard;
import org.nhindirect.common.tx.TxUtil;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.monitor.condition.TxCompletionCondition;
import org.nhindirect.monitor.condition.impl.AbstractCompletionCondition;

public class DSNMessageGenerator {
    protected final DSNGenerator generator;
    protected final String postmasterMailbox;
    protected final TxCompletionCondition conditionChecker;
    protected final String reportingMta;
    protected final DSNFailureTextBodyPartGenerator textGenerator;

    public DSNMessageGenerator(DSNGenerator generator, String postmasterMailbox, TxCompletionCondition conditionChecker, String reportingMta, DSNFailureTextBodyPartGenerator textGenerator) {
        this.generator = generator;
        this.postmasterMailbox = postmasterMailbox;
        this.conditionChecker = conditionChecker;
        this.reportingMta = reportingMta;
        this.textGenerator = textGenerator;
    }

    @Handler
    public void generateDSNFailureMessage(Collection<Tx> txs, Exchange ex) throws Exception {
        Collection<String> incompleteRecips;
        ex.getIn().setBody(null);
        Tx messageToTrack = AbstractCompletionCondition.getMessageToTrack(txs);
        if (messageToTrack != null && (incompleteRecips = this.conditionChecker.getIncompleteRecipients(txs)) != null && !incompleteRecips.isEmpty()) {
            TxDetail subject;
            InternetAddress originalSender = null;
            String originalSubject = "";
            InternetAddress postmaster = null;
            String originalMessageId = "";
            Enumeration<Header> fullMessageHeaders = null;
            ArrayList<DSNRecipientHeaders> recipientDSNHeaders = new ArrayList<DSNRecipientHeaders>();
            ArrayList<InternetAddress> failedRecipAddresses = new ArrayList<InternetAddress>();
            TxDetail sender = messageToTrack.getDetail(TxDetailType.FROM);
            if (sender != null) {
                originalSender = new InternetAddress(sender.getDetailValue());
                postmaster = new InternetAddress(this.postmasterMailbox + "@" + this.getAddressDomain(originalSender));
            }
            if ((subject = messageToTrack.getDetail(TxDetailType.SUBJECT)) != null) {
                originalSubject = subject.getDetailValue();
            }
            for (String incompleteRecip : incompleteRecips) {
                InternetAddress failedRecipAddress = new InternetAddress(incompleteRecip);
                DSNRecipientHeaders dsnRecipHeaders = new DSNRecipientHeaders(DSNStandard.DSNAction.FAILED, DSNStandard.DSNStatus.getStatus((int)5, (String)"0.0"), (Address)failedRecipAddress);
                recipientDSNHeaders.add(dsnRecipHeaders);
                failedRecipAddresses.add(failedRecipAddress);
            }
            TxDetail origMessId = messageToTrack.getDetail(TxDetailType.MSG_ID);
            if (origMessId != null) {
                originalMessageId = origMessId.getDetailValue();
            }
            DSNMessageHeaders messageDSNHeaders = new DSNMessageHeaders(this.reportingMta, originalMessageId, DSNStandard.MtaNameType.DNS);
            TxDetail fullHeaders = messageToTrack.getDetail(TxDetailType.MSG_FULL_HEADERS);
            if (fullHeaders != null) {
                fullMessageHeaders = this.convertStringToHeaders(fullHeaders.getDetailValue());
            }
            MimeBodyPart textBodyPart = this.textGenerator.generate((Address)originalSender, failedRecipAddresses, fullMessageHeaders);
            MimeMessage dnsMessage = this.generator.createDSNMessage(originalSender, originalSubject, postmaster, recipientDSNHeaders, messageDSNHeaders, textBodyPart);
            ex.getIn().setBody((Object)dnsMessage);
            if (TxUtil.isReliableAndTimelyRequested((Tx)messageToTrack)) {
                ex.setProperty("ORIG_IS_TIMELY", (Object)Boolean.TRUE);
            }
        }
    }

    protected String getAddressDomain(InternetAddress theAddress) {
        String retVal = "";
        String address = theAddress.getAddress();
        int index = address.indexOf(60);
        if (index > -1) {
            address = address.substring(index + 1);
        }
        if ((index = address.indexOf(62)) > -1) {
            address = address.substring(0, index);
        }
        if ((index = address.indexOf("@")) >= 0) {
            retVal = address.substring(index + 1);
        }
        return retVal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Enumeration<Header> convertStringToHeaders(String asString) {
        try (InputStream str = IOUtils.toInputStream((String)asString, (Charset)Charset.defaultCharset());){
            InternetHeaders headers = new InternetHeaders(str);
            Enumeration enumeration = headers.getAllHeaders();
            return enumeration;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

