/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.expression;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageIdCorrelationExpression
implements Expression {
    private static final Logger log = LoggerFactory.getLogger(MessageIdCorrelationExpression.class);

    public <String> String evaluate(Exchange exchange, Class<String> type) {
        String retVal = null;
        Tx tx = (Tx)exchange.getIn().getBody();
        TxMessageType msgType = tx.getMsgType();
        Map details = tx.getDetails();
        if (!details.isEmpty()) {
            switch (msgType) {
                case IMF: {
                    TxDetail msgIdDetail = (TxDetail)details.get(TxDetailType.MSG_ID.getType());
                    if (msgIdDetail == null) break;
                    retVal = msgIdDetail.getDetailValue().toString();
                    TxDetail recipients = tx.getDetail(TxDetailType.RECIPIENTS);
                    log.info("{} message to recipients '{}' with message ID '{}'", new Object[]{msgType, recipients == null ? null : recipients.getDetailValue(), retVal});
                    break;
                }
                case DSN: 
                case MDN: {
                    TxDetail msgIdDetail = (TxDetail)details.get(TxDetailType.PARENT_MSG_ID.getType());
                    if (msgIdDetail == null) break;
                    retVal = msgIdDetail.getDetailValue().toString();
                    TxDetail finalRecipients = tx.getDetail(TxDetailType.FINAL_RECIPIENTS);
                    TxDetail messageId = tx.getDetail(TxDetailType.MSG_ID);
                    TxDetail disposition = tx.getDetail(TxDetailType.DISPOSITION);
                    log.info("{} message for final recipients '{}' with message ID '{}' and parent message ID '{}'{}", new Object[]{msgType, finalRecipients == null ? null : finalRecipients.getDetailValue(), messageId == null ? null : messageId.getDetailValue(), retVal, msgType == TxMessageType.MDN ? " and disposition '" + (disposition == null ? null : disposition.getDetailValue()) + "'" : ""});
                    break;
                }
            }
        }
        return (String)retVal;
    }
}

