/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.condition.impl;

import java.util.Collection;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.monitor.condition.TxTimeoutCondition;

public class DecayingTimeoutCondition
implements TxTimeoutCondition {
    protected final long completionTimeout;

    public DecayingTimeoutCondition(long completionTimeout) {
        this.completionTimeout = completionTimeout;
    }

    @Override
    public long getTimeout(Collection<Tx> txs, long exchangeStartTime) {
        long timeSinceStart = this.getCurrentTime() - exchangeStartTime;
        long newTimeout = this.completionTimeout - timeSinceStart;
        if (newTimeout <= 0L) {
            newTimeout = 1L;
        }
        return newTimeout;
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }
}

