/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.aggregator.repository;

import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.hawtdb.HawtDBCamelCodec;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.support.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.hawtbuf.Buffer;
import org.nhindirect.monitor.entity.Aggregation;
import org.nhindirect.monitor.entity.AggregationCompleted;
import org.nhindirect.monitor.repository.AggregationCompletedRepository;
import org.nhindirect.monitor.repository.AggregationRepository;
import org.nhindirect.monitor.repository.AggregationRepositoryException;
import org.nhindirect.monitor.repository.AggregationVersionException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.transaction.annotation.Transactional;

public class ConcurrentJPAAggregationRepository
extends ServiceSupport
implements RecoverableAggregationRepository {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(ConcurrentJPAAggregationRepository.class);
    protected static final String AGGREGATION_ENTITY_VERSON = "AGGREGATION_ENTITY_VERSON";
    protected static final String AGGREGATION_COMPLETE_ENTITY_VERSON = "AGGREGATION_COMPLETE_ENTITY_VERSON";
    protected static final int DEFAULT_ENTITY_LOCK_INTERVAL = 120;
    protected int recoveredEntityLockInterval;
    protected HawtDBCamelCodec codec = new HawtDBCamelCodec();
    protected AggregationRepository aggRepo;
    protected AggregationCompletedRepository aggCompRepo;
    protected long recoveryInterval = 5000L;
    protected boolean useRecovery = true;
    protected int maximumRedeliveries;
    protected String deadLetterUri;

    public ConcurrentJPAAggregationRepository() {
        this.recoveredEntityLockInterval = 120;
    }

    public ConcurrentJPAAggregationRepository(AggregationRepository aggRepo, AggregationCompletedRepository aggCompRepo, int recoveredEntityLockInterval) {
        this.aggRepo = aggRepo;
        this.aggCompRepo = aggCompRepo;
    }

    public void setAggreationRepository(AggregationRepository aggRepo) {
        this.aggRepo = aggRepo;
    }

    public void setAggreationCompletedRepository(AggregationCompletedRepository aggCompRepo) {
        this.aggCompRepo = aggCompRepo;
    }

    public void setRecoveredEntityLockInterval(int recoveredEntityLockInterval) {
        this.recoveredEntityLockInterval = recoveredEntityLockInterval;
    }

    @Transactional
    public synchronized Exchange add(CamelContext camelContext, String key, Exchange exchange) {
        try {
            byte[] blob = this.codec.marshallExchange(camelContext, exchange, true).getData();
            Integer currentEntityVersion = (Integer)exchange.getProperty(AGGREGATION_ENTITY_VERSON);
            Aggregation agg = new Aggregation();
            agg.setExchangeBlob(blob);
            agg.setId(key);
            agg.setVersion(currentEntityVersion == null ? 0 : currentEntityVersion);
            Optional<Aggregation> existingAggrOpt = this.aggRepo.findById(key);
            if (!existingAggrOpt.isPresent() && agg.getVersion() > 0) {
                throw new AggregationVersionException("Aggregation not found but expected to exist due to non 0 version number");
            }
            if (existingAggrOpt.isPresent()) {
                Aggregation existingAggr = existingAggrOpt.get();
                if (existingAggr.getVersion() != agg.getVersion()) {
                    throw new AggregationVersionException("Version number of aggreation does not match what is in the store.");
                }
                existingAggr.setExchangeBlob(agg.getExchangeBlob());
                agg = (Aggregation)this.aggRepo.save(existingAggr);
            } else {
                agg = (Aggregation)this.aggRepo.save(agg);
            }
            exchange.setProperty(AGGREGATION_ENTITY_VERSON, (Object)agg.getVersion());
        }
        catch (Exception e) {
            throw new RuntimeException("Error adding to repository aggregation with key " + key, e);
        }
        return null;
    }

    public Exchange get(CamelContext camelContext, String key) {
        Exchange retVal = null;
        try {
            Aggregation keyAggregation = new Aggregation();
            keyAggregation.setId(key);
            Optional aggOpt = this.aggRepo.findOne(Example.of((Object)keyAggregation, (ExampleMatcher)ExampleMatcher.matching().withMatcher("id", match -> match.ignoreCase(true)).withIgnorePaths(new String[]{"blob", "version"})));
            if (!aggOpt.isPresent()) {
                return null;
            }
            Aggregation agg = (Aggregation)aggOpt.get();
            retVal = this.codec.unmarshallExchange(camelContext, new Buffer(agg.getExchangeBlob()));
            retVal.setProperty(AGGREGATION_ENTITY_VERSON, (Object)agg.getVersion());
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving from repository aggregation with key " + key, e);
        }
        return retVal;
    }

    @Transactional
    public void remove(CamelContext camelContext, String key, Exchange exchange) {
        try {
            Integer currentEntityVersion = (Integer)exchange.getProperty(AGGREGATION_ENTITY_VERSON);
            byte[] blob = this.codec.marshallExchange(camelContext, exchange, true).getData();
            Aggregation agg = new Aggregation();
            agg.setExchangeBlob(blob);
            agg.setId(key);
            agg.setVersion(currentEntityVersion == null ? 0 : currentEntityVersion);
            Optional<Aggregation> existingAggOpt = this.aggRepo.findById(key);
            if (!existingAggOpt.isPresent()) {
                throw new AggregationRepositoryException("Aggregation does not exist is store.");
            }
            Aggregation existingAgg = existingAggOpt.get();
            if (existingAgg.getVersion() != agg.getVersion()) {
                throw new AggregationVersionException("Version number of aggreation does not match what is in the store.");
            }
            this.aggRepo.delete(existingAgg);
            AggregationCompleted completed = new AggregationCompleted();
            completed.setExchangeBlob(existingAgg.getExchangeBlob());
            completed.setId(exchange.getExchangeId());
            completed.setVersion(1);
            this.aggCompRepo.save(completed);
        }
        catch (Exception e) {
            throw new RuntimeException("Error removing from repository aggregation with key " + key, e);
        }
    }

    public void confirm(CamelContext camelContext, String exchangeId) {
        try {
            this.aggCompRepo.deleteById(exchangeId);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
        }
        catch (Exception e) {
            throw new RuntimeException("Error confirming aggregation with key " + exchangeId, e);
        }
    }

    public Set<String> getKeys() {
        try {
            List<String> keys = this.aggRepo.findAllKeys();
            if (keys == null || keys.isEmpty()) {
                return Collections.emptySet();
            }
            return new LinkedHashSet<String>(keys);
        }
        catch (Exception e) {
            throw new RuntimeException("Error retriving aggregation keys", e);
        }
    }

    public Set<String> scan(CamelContext camelContext) {
        try {
            List<String> keys = this.aggCompRepo.findAllKeys();
            if (keys == null || keys.isEmpty()) {
                return Collections.emptySet();
            }
            return new LinkedHashSet<String>(keys);
        }
        catch (Exception e) {
            throw new RuntimeException("Error retriving aggregation completed keys", e);
        }
    }

    public Exchange recover(CamelContext camelContext, String exchangeId) {
        Exchange retVal = null;
        try {
            Optional aggOpt = this.aggCompRepo.findById(exchangeId);
            if (!aggOpt.isPresent()) {
                return null;
            }
            AggregationCompleted entity = (AggregationCompleted)aggOpt.get();
            if (entity.getRecoveryLockedUntilDtTm() != null && entity.getRecoveryLockedUntilDtTm().after(Calendar.getInstance(Locale.getDefault()))) {
                return null;
            }
            Calendar newRecoveryLockTime = Calendar.getInstance(Locale.getDefault());
            newRecoveryLockTime.add(13, this.recoveredEntityLockInterval);
            entity.setRecoveryLockedUntilDtTm(newRecoveryLockTime);
            this.aggCompRepo.save(entity);
            retVal = this.codec.unmarshallExchange(camelContext, new Buffer(entity.getExchangeBlob()));
            retVal.setProperty(AGGREGATION_COMPLETE_ENTITY_VERSON, (Object)entity.getVersion());
        }
        catch (Exception e) {
            throw new RuntimeException("Error recovering exchange from repository with exchangeId " + exchangeId, e);
        }
        retVal.setException(null);
        return retVal;
    }

    public void setRecoveryInterval(long interval, TimeUnit timeUnit) {
        this.recoveryInterval = timeUnit.toMillis(interval);
    }

    public void setRecoveryInterval(long interval) {
        this.recoveryInterval = interval;
    }

    public long getRecoveryIntervalInMillis() {
        return this.recoveryInterval;
    }

    public void setUseRecovery(boolean useRecovery) {
        this.useRecovery = useRecovery;
    }

    public boolean isUseRecovery() {
        return this.useRecovery;
    }

    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetterUri = deadLetterUri;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    protected void doStart() throws Exception {
        if (this.aggCompRepo == null || this.aggRepo == null) {
            throw new IllegalStateException("Aggregation respository sources cannot be null");
        }
        int current = this.getKeys().size();
        int completed = this.scan(null).size();
        if (current > 0) {
            LOGGER.info((Object)("On startup there are " + current + " aggregate exchanges (not completed) in repository"));
        } else {
            LOGGER.info((Object)"On startup there are no existing aggregate exchanges (not completed) in repository");
        }
        if (completed > 0) {
            LOGGER.warn((Object)("On startup there are " + completed + " completed exchanges to be recovered in repository"));
        } else {
            LOGGER.info((Object)"On startup there are no completed exchanges to be recovered in repository");
        }
    }

    protected void doStop() throws Exception {
    }
}

