/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.streams;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.UUID;
import org.apache.camel.ProducerTemplate;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.SpringBaseTest;
import org.nhindirect.monitor.streams.TxEventSink;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ActiveProfiles;

@ActiveProfiles(value={"streams"})
public class TxEventSinkTest
extends SpringBaseTest {
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private ProducerTemplate producerTemplate;
    @Autowired
    private TxEventSink sink;

    @Test
    public void testSendTxToSink() throws Exception {
        ProducerTemplate spyProducer = (ProducerTemplate)Mockito.spy((Object)this.producerTemplate);
        this.sink.setProducerTemplate(spyProducer);
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeReliableMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "", "");
        String marshedTx = this.mapper.writeValueAsString((Object)originalMessage);
        this.sink.directTxMonitoring().accept(marshedTx);
        ((ProducerTemplate)Mockito.verify((Object)spyProducer, (VerificationMode)Mockito.times((int)1))).sendBody(ArgumentMatchers.any());
    }
}

