/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.route;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.mail.internet.MimeMessage;
import org.apache.camel.CamelContext;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.SpringBaseTest;
import org.nhindirect.monitor.repository.ReceivedNotificationRepository;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(locations={"classpath:testTimeoutToDupStateManager.properties"}, properties={"direct.msgmonitor.condition.generalConditionTimeout=1000", "direct.msgmonitor.condition.reliableConditionTimeout=1000"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class TestTimeoutToDupStateManager
extends SpringBaseTest {
    @Autowired
    private ReceivedNotificationRepository recRepo;
    @Autowired
    protected CamelContext context;
    @EndpointInject(uri="direct:start")
    protected ProducerTemplate template;

    public void purgeNotifDAO(ReceivedNotificationRepository recRepo) throws Exception {
        Calendar qualTime = Calendar.getInstance(Locale.getDefault());
        qualTime.add(1, 10);
        recRepo.deleteByReceivedTimeBefore(qualTime);
    }

    @Test
    public void testTimeoutReliableMessage_conditionNotComplete_assertDupAdded() throws Exception {
        Assertions.assertNotNull((Object)this.recRepo);
        this.purgeNotifDAO(this.recRepo);
        MockEndpoint mock = (MockEndpoint)this.context.getEndpoint("mock:result", MockEndpoint.class);
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeReliableMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Thread.sleep(3000L);
        List exchanges = mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
        Exchange exchange = (Exchange)exchanges.iterator().next();
        MimeMessage message = (MimeMessage)exchange.getIn().getBody(MimeMessage.class);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((Object)"timeout", (Object)exchange.getProperty("CamelAggregatedCompletedBy"));
        String msgId = originalMessageId + "\t" + message.getMessageID();
        List addresses = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase(msgId.toUpperCase(), Arrays.asList("gm2552@direct.securehealthemail.com".toUpperCase()));
        Assertions.assertEquals((int)1, (int)addresses.size());
        Assertions.assertTrue((boolean)addresses.contains("gm2552@direct.securehealthemail.com"));
        addresses = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase(originalMessageId.toUpperCase(), Arrays.asList("gm2552@direct.securehealthemail.com".toUpperCase()));
        Assertions.assertEquals((int)1, (int)addresses.size());
        Assertions.assertTrue((boolean)addresses.contains("gm2552@direct.securehealthemail.com"));
    }

    @Test
    public void testTimeoutReliableMessage_conditionNotComplete_msgNotReliable_assertDupNotAdded() throws Exception {
        Assertions.assertNotNull((Object)this.recRepo);
        this.purgeNotifDAO(this.recRepo);
        MockEndpoint mock = (MockEndpoint)this.context.getEndpoint("mock:result", MockEndpoint.class);
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Thread.sleep(3000L);
        List exchanges = mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
        Exchange exchange = (Exchange)exchanges.iterator().next();
        MimeMessage messages = (MimeMessage)exchange.getIn().getBody(MimeMessage.class);
        Assertions.assertNotNull((Object)messages);
        Assertions.assertEquals((Object)"timeout", (Object)exchange.getProperty("CamelAggregatedCompletedBy"));
        List addresses = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase(originalMessageId.toUpperCase(), Arrays.asList("gm2552@direct.securehealthemail.com".toUpperCase()));
        Assertions.assertEquals((int)0, (int)addresses.size());
    }
}

