/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.route;

import java.util.List;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.mail.dsn.DSNStandard;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.SpringBaseTest;
import org.nhindirect.monitor.repository.AggregationCompletedRepository;
import org.nhindirect.monitor.repository.AggregationRepository;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"camel.springboot.xmlRoutes=classpath:routes/monitor-route-to-mock.xml"})
public class TestSingleRecipReliableMessageMonitorRoute
extends SpringBaseTest {
    @Autowired
    protected CamelContext context;
    @Autowired
    private AggregationRepository aggRepo;
    @Autowired
    private AggregationCompletedRepository aggCompRepo;
    protected MockEndpoint mock;
    protected ProducerTemplate template;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.aggRepo.deleteAll();
        this.aggCompRepo.deleteAll();
        this.mock = (MockEndpoint)this.context.getEndpoint("mock:result");
        this.mock.reset();
        this.template = this.context.createProducerTemplate();
    }

    @Test
    public void testSingleRecip_MDNProcessedReceived_assertConditionNotComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeReliableMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx mdnMessage = TestUtils.makeReliableMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "processed");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)0, (int)exchanges.size());
    }

    @Test
    public void testSingleRecip_MDNDispatchedReceived_assertConditionNotComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeReliableMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx mdnMessage = TestUtils.makeReliableMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "dispatched");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)0, (int)exchanges.size());
    }

    @Test
    public void testSingleRecip_MDNProcessedAndDisplayedReceived_assertConditionNotComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeReliableMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx mdnMessage = TestUtils.makeReliableMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "processed");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        mdnMessage = TestUtils.makeReliableMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "displayed");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)0, (int)exchanges.size());
    }

    @Test
    public void testSingleRecip_MDNProcessedAndDispatchedReceived_assertConditionComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeReliableMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx mdnMessage = TestUtils.makeReliableMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "processed");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        mdnMessage = TestUtils.makeReliableMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "dispatched");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
    }

    @Test
    public void testSingleRecip_MDNProcessedAndErrorReceived_assertConditionComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeReliableMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx mdnMessage = TestUtils.makeReliableMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "processed");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        mdnMessage = TestUtils.makeReliableMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "error");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
    }

    @Test
    public void testSingleRecip_MDNErrorReceived_assertConditionComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeReliableMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx mdnMessage = TestUtils.makeReliableMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "error");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
    }

    @Test
    public void testSingleRecip_MDNDeniedReceived_assertConditionComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeReliableMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx mdnMessage = TestUtils.makeReliableMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "denied");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
    }

    @Test
    public void testSingleRecip_DSNErroReceived_assertConditionComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeReliableMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx mdnMessage = TestUtils.makeReliableMessage(TxMessageType.DSN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", DSNStandard.DSNAction.FAILED.toString(), "");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
    }
}

