/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.route;

import java.util.List;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.SpringBaseTest;
import org.nhindirect.monitor.repository.AggregationCompletedRepository;
import org.nhindirect.monitor.repository.AggregationRepository;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"camel.springboot.xmlRoutes=classpath:routes/monitor-route-to-mock.xml"})
public class TestNonReliableMessageMonitorRoute
extends SpringBaseTest {
    @Autowired
    protected CamelContext context;
    @Autowired
    private AggregationRepository aggRepo;
    @Autowired
    private AggregationCompletedRepository aggCompRepo;
    protected MockEndpoint mock;
    protected ProducerTemplate template;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.aggRepo.deleteAll();
        this.aggCompRepo.deleteAll();
        this.mock = (MockEndpoint)this.context.getEndpoint("mock:result");
        this.mock.reset();
        this.template = this.context.createProducerTemplate();
    }

    @Test
    public void testSingleRecipMDNReceived_assertConditionComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
    }

    @Test
    public void testSingleRecipMDNReceived_multipleMessage_assertSingleConditionComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx secondMessage = TestUtils.makeMessage(TxMessageType.IMF, UUID.randomUUID().toString(), "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        this.template.sendBody("direct:start", (Object)secondMessage);
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
    }

    @Test
    public void testSingleRecipNoMDNReceived_assertConditionNotComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)0, (int)exchanges.size());
    }

    @Test
    public void testSingleRecipFailedDSNReceived_assertConditionComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.DSN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
    }

    @Test
    public void testMulitipleRecips_SingleMDNReceived_assertConditionNotComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com,ah4626@direct.securehealthemail.com", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)0, (int)exchanges.size());
    }

    @Test
    public void testMulitipleRecips_allMDNsReceived_assertConditionComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com,ah4626@direct.securehealthemail.com", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "ah4626@direct.securehealthemail.com", "gm2552@cerner.com", "ah4626@direct.securehealthemail.com");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
    }

    @Test
    public void testMulitipleRecips_MDNReceivedandDSNReceived_assertConditionComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com,ah4626@direct.securehealthemail.com", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        Tx dsnMessage = TestUtils.makeMessage(TxMessageType.DSN, UUID.randomUUID().toString(), originalMessageId, "ah4626@direct.securehealthemail.com", "gm2552@cerner.com", "ah4626@direct.securehealthemail.com");
        this.template.sendBody("direct:start", (Object)dsnMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
    }

    @Test
    public void testMulitipleRecips_singleDSNReceivedWithAllRecipeints_assertConditionComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com,ah4626@direct.securehealthemail.com", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx dsnMessage = TestUtils.makeMessage(TxMessageType.DSN, UUID.randomUUID().toString(), originalMessageId, "ah4626@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com,ah4626@direct.securehealthemail.com");
        this.template.sendBody("direct:start", (Object)dsnMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
    }

    @Test
    public void testMulitipleRecips_singleDSNReceivedWithOneRecipeints_assertConditionNotComplete() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com,ah4626@direct.securehealthemail.com", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx dsnMessage = TestUtils.makeMessage(TxMessageType.DSN, UUID.randomUUID().toString(), originalMessageId, "ah4626@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com");
        this.template.sendBody("direct:start", (Object)dsnMessage);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)0, (int)exchanges.size());
    }
}

