/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.route;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import javax.mail.internet.MimeMessage;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.mail.dsn.DSNStandard;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.SpringBaseTest;
import org.nhindirect.monitor.repository.AggregationCompletedRepository;
import org.nhindirect.monitor.repository.AggregationRepository;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(locations={"classpath:properties/shorttimeout.properties"}, properties={"camel.springboot.xmlRoutes=classpath:routes/monitor-route-to-error-message-generator.xml"})
public class TestNonCompletedToDSNGeneratorMonitorRoute
extends SpringBaseTest {
    @Autowired
    protected CamelContext context;
    @Autowired
    private AggregationRepository aggRepo;
    @Autowired
    private AggregationCompletedRepository aggCompRepo;
    protected MockEndpoint mock;
    protected ProducerTemplate template;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.aggRepo.deleteAll();
        this.aggCompRepo.deleteAll();
        this.mock = (MockEndpoint)this.context.getEndpoint("mock:result");
        this.mock.reset();
        this.template = this.context.createProducerTemplate();
    }

    @Test
    public void testNonCompleted_assertDSNGenerated() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com,ah4626@direct.securehealthemail.com", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Thread.sleep(3000L);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
    }

    @Test
    public void testNonCompleted_multipleRecipeints_singleCompletedSuccessfully_assertDSNGeneratedAndValidTimedout() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com,ah4626@direct.securehealthemail.com", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "processed");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        Thread.sleep(3000L);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
        MimeMessage dsnMessage = (MimeMessage)((Exchange)exchanges.get(0)).getIn().getBody();
        ByteArrayOutputStream oStr = new ByteArrayOutputStream();
        dsnMessage.writeTo((OutputStream)oStr);
        String str = new String(oStr.toByteArray());
        Assertions.assertTrue((boolean)str.contains("ah4626@direct.securehealthemail.com"));
        Assertions.assertFalse((boolean)str.contains("gm2552@direct.securehealthemail.com"));
    }

    @Test
    public void testNonCompleted_multipleRecipeints_singleDSNAndOneIncomplete_assertDSNGeneratedAndValidTimedout() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com,ah4626@direct.securehealthemail.com", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx dsntxMessage = TestUtils.makeMessage(TxMessageType.DSN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", DSNStandard.DSNAction.FAILED.toString(), "");
        this.template.sendBody("direct:start", (Object)dsntxMessage);
        Thread.sleep(3000L);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
        MimeMessage dsnMessage = (MimeMessage)((Exchange)exchanges.get(0)).getIn().getBody();
        ByteArrayOutputStream oStr = new ByteArrayOutputStream();
        dsnMessage.writeTo((OutputStream)oStr);
        String str = new String(oStr.toByteArray());
        Assertions.assertTrue((boolean)str.contains("ah4626@direct.securehealthemail.com"));
        Assertions.assertFalse((boolean)str.contains("gm2552@direct.securehealthemail.com"));
    }

    @Test
    public void testNonCompleted_multipleRecipeints_singleDSNSingleProcessAndOneIncomplete_assertDSNGeneratedAndValidTimedout() throws Exception {
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com,ah4626@direct.securehealthemail.com,gm2552@test.com", "");
        this.template.sendBody("direct:start", (Object)originalMessage);
        Tx dsntxMessage = TestUtils.makeMessage(TxMessageType.DSN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", DSNStandard.DSNAction.FAILED.toString(), "");
        this.template.sendBody("direct:start", (Object)dsntxMessage);
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "ah4626@direct.securehealthemail.com", "gm2552@cerner.com", "ah4626@direct.securehealthemail.com", "", "processed");
        this.template.sendBody("direct:start", (Object)mdnMessage);
        Thread.sleep(3000L);
        List exchanges = this.mock.getReceivedExchanges();
        Assertions.assertEquals((int)1, (int)exchanges.size());
        MimeMessage dsnMessage = (MimeMessage)((Exchange)exchanges.get(0)).getIn().getBody();
        ByteArrayOutputStream oStr = new ByteArrayOutputStream();
        dsnMessage.writeTo((OutputStream)oStr);
        String str = new String(oStr.toByteArray());
        Assertions.assertFalse((boolean)str.contains("ah4626@direct.securehealthemail.com"));
        Assertions.assertFalse((boolean)str.contains("gm2552@direct.securehealthemail.com"));
        Assertions.assertTrue((boolean)str.contains("gm2552@test.com"));
    }
}

