/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.BaseTestPlan;
import org.nhindirect.monitor.SpringBaseTest;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.reactive.function.client.WebClient;

public class TxsResource_addTxWebTest
extends SpringBaseTest {
    @Autowired
    protected CamelContext context;
    @Autowired
    protected ApplicationContext ctx;

    @Test
    public void testSingleRecipMDNReceived_assertConditionComplete() throws Exception {
        new TestPlan(){

            @Override
            protected Collection<Tx> getTxsToSubmit() {
                ArrayList<Tx> txs = new ArrayList<Tx>();
                String originalMessageId = UUID.randomUUID().toString();
                Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
                txs.add(originalMessage);
                Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com");
                txs.add(mdnMessage);
                return txs;
            }

            @Override
            protected void doAssertions(MockEndpoint mock) throws Exception {
                List exchanges = mock.getReceivedExchanges();
                Assertions.assertEquals((int)1, (int)exchanges.size());
                Collection txs = (Collection)((Exchange)exchanges.iterator().next()).getIn().getBody();
                Assertions.assertEquals((int)2, (int)txs.size());
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected MockEndpoint mockEndpoint = null;

        TestPlan() {
        }

        @Override
        protected void setupMocks() {
            try {
                this.mockEndpoint = (MockEndpoint)TxsResource_addTxWebTest.this.context.getEndpoint("mock:result", MockEndpoint.class);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        @Override
        protected void tearDownMocks() {
        }

        protected Collection<Tx> getTxsToSubmit() {
            return Collections.emptyList();
        }

        @Override
        protected void performInner() throws Exception {
            Collection<Tx> txs = this.getTxsToSubmit();
            if (txs != null) {
                txs.forEach(tx -> ((WebClient.RequestBodySpec)TxsResource_addTxWebTest.this.webClient.post().uri("/txs", new Object[0])).bodyValue(tx).retrieve().bodyToMono(Void.class).block());
            }
            this.doAssertions(this.mockEndpoint);
        }

        protected void doAssertions(MockEndpoint mock) throws Exception {
        }
    }
}

